<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitySearchMetadata StructType
 * @subpackage Structs
 */
class EntitySearchMetadata extends AbstractStructBase
{
    /**
     * The entityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $entityName;
    /**
     * The errorMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata
     */
    public $errorMetadata;
    /**
     * The fieldMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata[]
     */
    public $fieldMetadata;
    /**
     * The intentQueryMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata
     */
    public $intentQueryMetadata;
    /**
     * The searchPromotionMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata
     */
    public $searchPromotionMetadata;
    /**
     * The spellCorrectionMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata
     */
    public $spellCorrectionMetadata;
    /**
     * Constructor method for EntitySearchMetadata
     * @uses EntitySearchMetadata::setEntityName()
     * @uses EntitySearchMetadata::setErrorMetadata()
     * @uses EntitySearchMetadata::setFieldMetadata()
     * @uses EntitySearchMetadata::setIntentQueryMetadata()
     * @uses EntitySearchMetadata::setSearchPromotionMetadata()
     * @uses EntitySearchMetadata::setSpellCorrectionMetadata()
     * @param string $entityName
     * @param \AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata $errorMetadata
     * @param \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata[] $fieldMetadata
     * @param \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata $intentQueryMetadata
     * @param \AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata $searchPromotionMetadata
     * @param \AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata $spellCorrectionMetadata
     */
    public function __construct($entityName = null, \AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata $errorMetadata = null, array $fieldMetadata = array(), \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata $intentQueryMetadata = null, \AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata $searchPromotionMetadata = null, \AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata $spellCorrectionMetadata = null)
    {
        $this
            ->setEntityName($entityName)
            ->setErrorMetadata($errorMetadata)
            ->setFieldMetadata($fieldMetadata)
            ->setIntentQueryMetadata($intentQueryMetadata)
            ->setSearchPromotionMetadata($searchPromotionMetadata)
            ->setSpellCorrectionMetadata($spellCorrectionMetadata);
    }
    /**
     * Get entityName value
     * @return string
     */
    public function getEntityName()
    {
        return $this->entityName;
    }
    /**
     * Set entityName value
     * @param string $entityName
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        $this->entityName = $entityName;
        return $this;
    }
    /**
     * Get errorMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata|null
     */
    public function getErrorMetadata()
    {
        return $this->errorMetadata;
    }
    /**
     * Set errorMetadata value
     * @param \AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata $errorMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setErrorMetadata(\AfhcFacilityFinder\SForce\StructType\EntityErrorMetadata $errorMetadata = null)
    {
        $this->errorMetadata = $errorMetadata;
        return $this;
    }
    /**
     * Get fieldMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata[]|null
     */
    public function getFieldMetadata()
    {
        return $this->fieldMetadata;
    }
    /**
     * This method is responsible for validating the values passed to the setFieldMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFieldMetadata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldMetadataForArrayConstraintsFromSetFieldMetadata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entitySearchMetadataFieldMetadataItem) {
            // validation for constraint: itemType
            if (!$entitySearchMetadataFieldMetadataItem instanceof \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata) {
                $invalidValues[] = is_object($entitySearchMetadataFieldMetadataItem) ? get_class($entitySearchMetadataFieldMetadataItem) : sprintf('%s(%s)', gettype($entitySearchMetadataFieldMetadataItem), var_export($entitySearchMetadataFieldMetadataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fieldMetadata property can only contain items of type \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fieldMetadata value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata[] $fieldMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setFieldMetadata(array $fieldMetadata = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldMetadataArrayErrorMessage = self::validateFieldMetadataForArrayConstraintsFromSetFieldMetadata($fieldMetadata))) {
            throw new \InvalidArgumentException($fieldMetadataArrayErrorMessage, __LINE__);
        }
        $this->fieldMetadata = $fieldMetadata;
        return $this;
    }
    /**
     * Add item to fieldMetadata value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata $item
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function addToFieldMetadata(\AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata) {
            throw new \InvalidArgumentException(sprintf('The fieldMetadata property can only contain items of type \AfhcFacilityFinder\SForce\StructType\FieldLevelSearchMetadata, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fieldMetadata[] = $item;
        return $this;
    }
    /**
     * Get intentQueryMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata|null
     */
    public function getIntentQueryMetadata()
    {
        return $this->intentQueryMetadata;
    }
    /**
     * Set intentQueryMetadata value
     * @param \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata $intentQueryMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setIntentQueryMetadata(\AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata $intentQueryMetadata = null)
    {
        $this->intentQueryMetadata = $intentQueryMetadata;
        return $this;
    }
    /**
     * Get searchPromotionMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata|null
     */
    public function getSearchPromotionMetadata()
    {
        return $this->searchPromotionMetadata;
    }
    /**
     * Set searchPromotionMetadata value
     * @param \AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata $searchPromotionMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setSearchPromotionMetadata(\AfhcFacilityFinder\SForce\StructType\EntitySearchPromotionMetadata $searchPromotionMetadata = null)
    {
        $this->searchPromotionMetadata = $searchPromotionMetadata;
        return $this;
    }
    /**
     * Get spellCorrectionMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata|null
     */
    public function getSpellCorrectionMetadata()
    {
        return $this->spellCorrectionMetadata;
    }
    /**
     * Set spellCorrectionMetadata value
     * @param \AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata $spellCorrectionMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\EntitySearchMetadata
     */
    public function setSpellCorrectionMetadata(\AfhcFacilityFinder\SForce\StructType\EntitySpellCorrectionMetadata $spellCorrectionMetadata = null)
    {
        $this->spellCorrectionMetadata = $spellCorrectionMetadata;
        return $this;
    }
}
