<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebuggingInfo StructType
 * @subpackage Structs
 */
class DebuggingInfo extends AbstractStructBase
{
    /**
     * The debugLog
     * @var string
     */
    public $debugLog;
    /**
     * Constructor method for DebuggingInfo
     * @uses DebuggingInfo::setDebugLog()
     * @param string $debugLog
     */
    public function __construct($debugLog = null)
    {
        $this
            ->setDebugLog($debugLog);
    }
    /**
     * Get debugLog value
     * @return string|null
     */
    public function getDebugLog()
    {
        return $this->debugLog;
    }
    /**
     * Set debugLog value
     * @param string $debugLog
     * @return \AfhcFacilityFinder\SForce\StructType\DebuggingInfo
     */
    public function setDebugLog($debugLog = null)
    {
        // validation for constraint: string
        if (!is_null($debugLog) && !is_string($debugLog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debugLog, true), gettype($debugLog)), __LINE__);
        }
        $this->debugLog = $debugLog;
        return $this;
    }
}
