<?php

namespace AfhcFacilityFinder\SForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the CallOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCallOptions(\AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CallOptions', $callOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the MruHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\MruHeader $mruHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMruHeader(\AfhcFacilityFinder\SForce\StructType\MruHeader $mruHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MruHeader', $mruHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named executeListView
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, MruHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\MruHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Execute the specified list view and return the presentation-ready results.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\ExecuteListView $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\ExecuteListViewResponse|bool
     */
    public function executeListView(\AfhcFacilityFinder\SForce\StructType\ExecuteListView $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->executeListView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AfhcFacilityFinder\SForce\StructType\ExecuteListViewResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
