<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleNameObjectValuePair StructType
 * @subpackage Structs
 */
class SimpleNameObjectValuePair extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The value
     * @var mixed
     */
    public $value;
    /**
     * Constructor method for SimpleNameObjectValuePair
     * @uses SimpleNameObjectValuePair::setName()
     * @uses SimpleNameObjectValuePair::setValue()
     * @param string $name
     * @param mixed $value
     */
    public function __construct($name = null, $value = null)
    {
        $this
            ->setName($name)
            ->setValue($value);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AfhcFacilityFinder\SForce\StructType\SimpleNameObjectValuePair
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get value value
     * @return mixed|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param mixed $value
     * @return \AfhcFacilityFinder\SForce\StructType\SimpleNameObjectValuePair
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
}
