<?php

namespace AfhcFacilityFinder\SForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the CallOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCallOptions(\AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CallOptions', $callOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the QueryOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\QueryOptions $queryOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderQueryOptions(\AfhcFacilityFinder\SForce\StructType\QueryOptions $queryOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'QueryOptions', $queryOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the MruHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\MruHeader $mruHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMruHeader(\AfhcFacilityFinder\SForce\StructType\MruHeader $mruHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MruHeader', $mruHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named retrieve
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, QueryOptions, MruHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\QueryOptions, \AfhcFacilityFinder\SForce\StructType\MruHeader, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required, required, required
     * - documentation: Get a set of sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\Retrieve $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\RetrieveResponse|bool
     */
    public function retrieve(\AfhcFacilityFinder\SForce\StructType\Retrieve $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->retrieve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveQuickActionTemplates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Retrieve the template sobjects, if appropriate, for the given quick action names in a given context
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\RetrieveQuickActionTemplates $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\RetrieveQuickActionTemplatesResponse|bool
     */
    public function retrieveQuickActionTemplates(\AfhcFacilityFinder\SForce\StructType\RetrieveQuickActionTemplates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->retrieveQuickActionTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveMassQuickActionTemplates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Retrieve the template sobjects, if appropriate, for the given quick action names in a given contexts when used a mass quick action
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\RetrieveMassQuickActionTemplates $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\RetrieveMassQuickActionTemplatesResponse|bool
     */
    public function retrieveMassQuickActionTemplates(\AfhcFacilityFinder\SForce\StructType\RetrieveMassQuickActionTemplates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->retrieveMassQuickActionTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AfhcFacilityFinder\SForce\StructType\RetrieveMassQuickActionTemplatesResponse|\AfhcFacilityFinder\SForce\StructType\RetrieveQuickActionTemplatesResponse|\AfhcFacilityFinder\SForce\StructType\RetrieveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
