<?php

namespace AfhcFacilityFinder\SForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Describe ServiceType
 * @subpackage Services
 */
class Describe extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the CallOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCallOptions(\AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CallOptions', $callOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named describeSObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe an sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSObject $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSObjectResponse|bool
     */
    public function describeSObject(\AfhcFacilityFinder\SForce\StructType\DescribeSObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSObjects
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe multiple sObjects (upto 100)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSObjects $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSObjectsResponse|bool
     */
    public function describeSObjects(\AfhcFacilityFinder\SForce\StructType\DescribeSObjects $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSObjects($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeGlobal
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the Global state
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeGlobal $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeGlobalResponse|bool
     */
    public function describeGlobal(\AfhcFacilityFinder\SForce\StructType\DescribeGlobal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeGlobal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeDataCategoryGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe all the data category groups available for a given set of types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroups $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupsResponse|bool
     */
    public function describeDataCategoryGroups(\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeDataCategoryGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * describeDataCategoryGroupStructures
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe the data category group structures for a given set of pair of types and data category group name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupStructures $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupStructuresResponse|bool
     */
    public function describeDataCategoryGroupStructures(\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupStructures $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeDataCategoryGroupStructures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeDataCategoryMappings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe your Data Category Mappings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryMappings $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryMappingsResponse|bool
     */
    public function describeDataCategoryMappings(\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryMappings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeDataCategoryMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeKnowledgeSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describes your Knowledge settings, such as if knowledgeEnabled is on or off, its default language and supported languages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeKnowledgeSettings $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeKnowledgeSettingsResponse|bool
     */
    public function describeKnowledgeSettings(\AfhcFacilityFinder\SForce\StructType\DescribeKnowledgeSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeKnowledgeSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAppMenu
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the items in an AppMenu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeAppMenu $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeAppMenuResponse|bool
     */
    public function describeAppMenu(\AfhcFacilityFinder\SForce\StructType\DescribeAppMenu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeAppMenu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeGlobalTheme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe Gloal and Themes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeGlobalTheme_1 $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeGlobalThemeResponse|bool
     */
    public function describeGlobalTheme(\AfhcFacilityFinder\SForce\StructType\DescribeGlobalTheme_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeGlobalTheme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeTheme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe Themes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeTheme $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeThemeResponse|bool
     */
    public function describeTheme(\AfhcFacilityFinder\SForce\StructType\DescribeTheme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeTheme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeLayout
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the layout of the given sObject or the given actionable global page.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayout_1 $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResponse|bool
     */
    public function describeLayout(\AfhcFacilityFinder\SForce\StructType\DescribeLayout_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSoftphoneLayout
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the layout of the SoftPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSoftphoneLayout $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSoftphoneLayoutResponse|bool
     */
    public function describeSoftphoneLayout(\AfhcFacilityFinder\SForce\StructType\DescribeSoftphoneLayout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSoftphoneLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchLayouts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the search view of an sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSearchLayouts $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSearchLayoutsResponse|bool
     */
    public function describeSearchLayouts(\AfhcFacilityFinder\SForce\StructType\DescribeSearchLayouts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSearchLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchableEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe a list of entity names that reflects the current user's searchable entities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSearchableEntities $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSearchableEntitiesResponse|bool
     */
    public function describeSearchableEntities(\AfhcFacilityFinder\SForce\StructType\DescribeSearchableEntities $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSearchableEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchScopeOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe a list of objects representing the order and scope of objects on a users search result page
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSearchScopeOrder $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSearchScopeOrderResponse|bool
     */
    public function describeSearchScopeOrder(\AfhcFacilityFinder\SForce\StructType\DescribeSearchScopeOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSearchScopeOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeCompactLayouts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the compact layouts of the given sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeCompactLayouts $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeCompactLayoutsResponse|bool
     */
    public function describeCompactLayouts(\AfhcFacilityFinder\SForce\StructType\DescribeCompactLayouts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeCompactLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describePathAssistants
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the Path Assistants for the given sObject and optionally RecordTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribePathAssistants $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribePathAssistantsResponse|bool
     */
    public function describePathAssistants(\AfhcFacilityFinder\SForce\StructType\DescribePathAssistants $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describePathAssistants($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeApprovalLayout
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the approval layouts of the given sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeApprovalLayout_1 $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeApprovalLayoutResponse|bool
     */
    public function describeApprovalLayout(\AfhcFacilityFinder\SForce\StructType\DescribeApprovalLayout_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeApprovalLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSoqlListViews
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the ListViews as SOQL metadata for the generation of SOQL.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSoqlListViews $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSoqlListViewsResponse|bool
     */
    public function describeSoqlListViews(\AfhcFacilityFinder\SForce\StructType\DescribeSoqlListViews $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSoqlListViews($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSObjectListViews
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the ListViews of a SObject as SOQL metadata for the generation of SOQL.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeSObjectListViews $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeSObjectListViewsResponse|bool
     */
    public function describeSObjectListViews(\AfhcFacilityFinder\SForce\StructType\DescribeSObjectListViews $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeSObjectListViews($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeTabs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the tabs that appear on a users page
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeTabs $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeTabsResponse|bool
     */
    public function describeTabs(\AfhcFacilityFinder\SForce\StructType\DescribeTabs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeTabs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAllTabs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe all tabs available to a user
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeAllTabs $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeAllTabsResponse|bool
     */
    public function describeAllTabs(\AfhcFacilityFinder\SForce\StructType\DescribeAllTabs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeAllTabs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describePrimaryCompactLayouts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the primary compact layouts for the sObjects requested
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribePrimaryCompactLayouts $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribePrimaryCompactLayoutsResponse|bool
     */
    public function describePrimaryCompactLayouts(\AfhcFacilityFinder\SForce\StructType\DescribePrimaryCompactLayouts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describePrimaryCompactLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeQuickActions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe the details of a series of quick actions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeQuickActions $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsResponse|bool
     */
    public function describeQuickActions(\AfhcFacilityFinder\SForce\StructType\DescribeQuickActions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeQuickActions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeQuickActionsForRecordType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe the details of a series of quick actions in context of requested recordType id for Update actions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsForRecordType $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsForRecordTypeResponse|bool
     */
    public function describeQuickActionsForRecordType(\AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsForRecordType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeQuickActionsForRecordType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAvailableQuickActions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Describe the details of a series of quick actions available for the given contextType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeAvailableQuickActions $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeAvailableQuickActionsResponse|bool
     */
    public function describeAvailableQuickActions(\AfhcFacilityFinder\SForce\StructType\DescribeAvailableQuickActions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeAvailableQuickActions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeVisualForce
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required
     * - documentation: Describe visualforce for an org
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeVisualForce $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeVisualForceResponse|bool
     */
    public function describeVisualForce(\AfhcFacilityFinder\SForce\StructType\DescribeVisualForce $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeVisualForce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeNouns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required, required
     * - documentation: Return the renameable nouns from the server for use in presentation using the salesforce grammar engine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeNouns $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeNounsResponse|bool
     */
    public function describeNouns(\AfhcFacilityFinder\SForce\StructType\DescribeNouns $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->describeNouns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeAllTabsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeAppMenuResponse|\AfhcFacilityFinder\SForce\StructType\DescribeApprovalLayoutResponse|\AfhcFacilityFinder\SForce\StructType\DescribeAvailableQuickActionsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeCompactLayoutsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupStructuresResponse|\AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryMappingsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeGlobalResponse|\AfhcFacilityFinder\SForce\StructType\DescribeGlobalThemeResponse|\AfhcFacilityFinder\SForce\StructType\DescribeKnowledgeSettingsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeLayoutResponse|\AfhcFacilityFinder\SForce\StructType\DescribeNounsResponse|\AfhcFacilityFinder\SForce\StructType\DescribePathAssistantsResponse|\AfhcFacilityFinder\SForce\StructType\DescribePrimaryCompactLayoutsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsForRecordTypeResponse|\AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSearchableEntitiesResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSearchLayoutsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSearchScopeOrderResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSObjectListViewsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSObjectResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSObjectsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSoftphoneLayoutResponse|\AfhcFacilityFinder\SForce\StructType\DescribeSoqlListViewsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeTabsResponse|\AfhcFacilityFinder\SForce\StructType\DescribeThemeResponse|\AfhcFacilityFinder\SForce\StructType\DescribeVisualForceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
