<?php

namespace AfhcFacilityFinder\SForce\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for LogCategoryLevel EnumType
 * @subpackage Enumerations
 */
class LogCategoryLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Finest'
     * @return string 'Finest'
     */
    const VALUE_FINEST = 'Finest';
    /**
     * Constant for value 'Finer'
     * @return string 'Finer'
     */
    const VALUE_FINER = 'Finer';
    /**
     * Constant for value 'Fine'
     * @return string 'Fine'
     */
    const VALUE_FINE = 'Fine';
    /**
     * Constant for value 'Debug'
     * @return string 'Debug'
     */
    const VALUE_DEBUG = 'Debug';
    /**
     * Constant for value 'Info'
     * @return string 'Info'
     */
    const VALUE_INFO = 'Info';
    /**
     * Constant for value 'Warn'
     * @return string 'Warn'
     */
    const VALUE_WARN = 'Warn';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_FINEST
     * @uses self::VALUE_FINER
     * @uses self::VALUE_FINE
     * @uses self::VALUE_DEBUG
     * @uses self::VALUE_INFO
     * @uses self::VALUE_WARN
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_FINEST,
            self::VALUE_FINER,
            self::VALUE_FINE,
            self::VALUE_DEBUG,
            self::VALUE_INFO,
            self::VALUE_WARN,
            self::VALUE_ERROR,
        );
    }
}
