<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRecord StructType
 * @subpackage Structs
 */
class SearchRecord extends AbstractStructBase
{
    /**
     * The record
     * @var \AfhcFacilityFinder\SForce\StructType\SObject
     */
    public $record;
    /**
     * The searchRecordMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata
     */
    public $searchRecordMetadata;
    /**
     * The snippet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AfhcFacilityFinder\SForce\StructType\SearchSnippet
     */
    public $snippet;
    /**
     * Constructor method for SearchRecord
     * @uses SearchRecord::setRecord()
     * @uses SearchRecord::setSearchRecordMetadata()
     * @uses SearchRecord::setSnippet()
     * @param \AfhcFacilityFinder\SForce\StructType\SObject $record
     * @param \AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata $searchRecordMetadata
     * @param \AfhcFacilityFinder\SForce\StructType\SearchSnippet $snippet
     */
    public function __construct(\AfhcFacilityFinder\SForce\StructType\SObject $record = null, \AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata $searchRecordMetadata = null, \AfhcFacilityFinder\SForce\StructType\SearchSnippet $snippet = null)
    {
        $this
            ->setRecord($record)
            ->setSearchRecordMetadata($searchRecordMetadata)
            ->setSnippet($snippet);
    }
    /**
     * Get record value
     * @return \AfhcFacilityFinder\SForce\StructType\SObject|null
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * Set record value
     * @param \AfhcFacilityFinder\SForce\StructType\SObject $record
     * @return \AfhcFacilityFinder\SForce\StructType\SearchRecord
     */
    public function setRecord(\AfhcFacilityFinder\SForce\StructType\SObject $record = null)
    {
        $this->record = $record;
        return $this;
    }
    /**
     * Get searchRecordMetadata value
     * @return \AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata|null
     */
    public function getSearchRecordMetadata()
    {
        return $this->searchRecordMetadata;
    }
    /**
     * Set searchRecordMetadata value
     * @param \AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata $searchRecordMetadata
     * @return \AfhcFacilityFinder\SForce\StructType\SearchRecord
     */
    public function setSearchRecordMetadata(\AfhcFacilityFinder\SForce\StructType\SearchRecordMetadata $searchRecordMetadata = null)
    {
        $this->searchRecordMetadata = $searchRecordMetadata;
        return $this;
    }
    /**
     * Get snippet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AfhcFacilityFinder\SForce\StructType\SearchSnippet|null
     */
    public function getSnippet()
    {
        return isset($this->snippet) ? $this->snippet : null;
    }
    /**
     * Set snippet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AfhcFacilityFinder\SForce\StructType\SearchSnippet $snippet
     * @return \AfhcFacilityFinder\SForce\StructType\SearchRecord
     */
    public function setSnippet(\AfhcFacilityFinder\SForce\StructType\SearchSnippet $snippet = null)
    {
        if (is_null($snippet) || (is_array($snippet) && empty($snippet))) {
            unset($this->snippet);
        } else {
            $this->snippet = $snippet;
        }
        return $this;
    }
}
