<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryOptions StructType
 * @subpackage Structs
 */
class QueryOptions extends AbstractStructBase
{
    /**
     * The batchSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $batchSize;
    /**
     * Constructor method for QueryOptions
     * @uses QueryOptions::setBatchSize()
     * @param int $batchSize
     */
    public function __construct($batchSize = null)
    {
        $this
            ->setBatchSize($batchSize);
    }
    /**
     * Get batchSize value
     * @return int|null
     */
    public function getBatchSize()
    {
        return $this->batchSize;
    }
    /**
     * Set batchSize value
     * @param int $batchSize
     * @return \AfhcFacilityFinder\SForce\StructType\QueryOptions
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !(is_int($batchSize) || ctype_digit($batchSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchSize, true), gettype($batchSize)), __LINE__);
        }
        $this->batchSize = $batchSize;
        return $this;
    }
}
