<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogInfo StructType
 * @subpackage Structs
 */
class LogInfo extends AbstractStructBase
{
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * The level
     * @var string
     */
    public $level;
    /**
     * Constructor method for LogInfo
     * @uses LogInfo::setCategory()
     * @uses LogInfo::setLevel()
     * @param string $category
     * @param string $level
     */
    public function __construct($category = null, $level = null)
    {
        $this
            ->setCategory($category)
            ->setLevel($level);
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @uses \AfhcFacilityFinder\SForce\EnumType\LogCategory::valueIsValid()
     * @uses \AfhcFacilityFinder\SForce\EnumType\LogCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \AfhcFacilityFinder\SForce\StructType\LogInfo
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\AfhcFacilityFinder\SForce\EnumType\LogCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \AfhcFacilityFinder\SForce\EnumType\LogCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \AfhcFacilityFinder\SForce\EnumType\LogCategory::getValidValues())), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @uses \AfhcFacilityFinder\SForce\EnumType\LogCategoryLevel::valueIsValid()
     * @uses \AfhcFacilityFinder\SForce\EnumType\LogCategoryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \AfhcFacilityFinder\SForce\StructType\LogInfo
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\AfhcFacilityFinder\SForce\EnumType\LogCategoryLevel::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \AfhcFacilityFinder\SForce\EnumType\LogCategoryLevel', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \AfhcFacilityFinder\SForce\EnumType\LogCategoryLevel::getValidValues())), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
}
