<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityIntentQueryMetadata StructType
 * @subpackage Structs
 */
class EntityIntentQueryMetadata extends AbstractStructBase
{
    /**
     * The intentQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $intentQuery;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * Constructor method for EntityIntentQueryMetadata
     * @uses EntityIntentQueryMetadata::setIntentQuery()
     * @uses EntityIntentQueryMetadata::setMessage()
     * @param bool $intentQuery
     * @param string $message
     */
    public function __construct($intentQuery = null, $message = null)
    {
        $this
            ->setIntentQuery($intentQuery)
            ->setMessage($message);
    }
    /**
     * Get intentQuery value
     * @return bool
     */
    public function getIntentQuery()
    {
        return $this->intentQuery;
    }
    /**
     * Set intentQuery value
     * @param bool $intentQuery
     * @return \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata
     */
    public function setIntentQuery($intentQuery = null)
    {
        // validation for constraint: boolean
        if (!is_null($intentQuery) && !is_bool($intentQuery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intentQuery, true), gettype($intentQuery)), __LINE__);
        }
        $this->intentQuery = $intentQuery;
        return $this;
    }
    /**
     * Get message value
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \AfhcFacilityFinder\SForce\StructType\EntityIntentQueryMetadata
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
