<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescribeLayoutResult StructType
 * @subpackage Structs
 */
class DescribeLayoutResult extends AbstractStructBase
{
    /**
     * The layouts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayout[]
     */
    public $layouts;
    /**
     * The recordTypeMappings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping[]
     */
    public $recordTypeMappings;
    /**
     * The recordTypeSelectorRequired
     * @var bool
     */
    public $recordTypeSelectorRequired;
    /**
     * Constructor method for DescribeLayoutResult
     * @uses DescribeLayoutResult::setLayouts()
     * @uses DescribeLayoutResult::setRecordTypeMappings()
     * @uses DescribeLayoutResult::setRecordTypeSelectorRequired()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayout[] $layouts
     * @param \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping[] $recordTypeMappings
     * @param bool $recordTypeSelectorRequired
     */
    public function __construct(array $layouts = array(), array $recordTypeMappings = array(), $recordTypeSelectorRequired = null)
    {
        $this
            ->setLayouts($layouts)
            ->setRecordTypeMappings($recordTypeMappings)
            ->setRecordTypeSelectorRequired($recordTypeSelectorRequired);
    }
    /**
     * Get layouts value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout[]
     */
    public function getLayouts()
    {
        return $this->layouts;
    }
    /**
     * This method is responsible for validating the values passed to the setLayouts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLayouts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLayoutsForArrayConstraintsFromSetLayouts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutResultLayoutsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutResultLayoutsItem instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayout) {
                $invalidValues[] = is_object($describeLayoutResultLayoutsItem) ? get_class($describeLayoutResultLayoutsItem) : sprintf('%s(%s)', gettype($describeLayoutResultLayoutsItem), var_export($describeLayoutResultLayoutsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The layouts property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayout, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set layouts value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayout[] $layouts
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResult
     */
    public function setLayouts(array $layouts = array())
    {
        // validation for constraint: array
        if ('' !== ($layoutsArrayErrorMessage = self::validateLayoutsForArrayConstraintsFromSetLayouts($layouts))) {
            throw new \InvalidArgumentException($layoutsArrayErrorMessage, __LINE__);
        }
        $this->layouts = $layouts;
        return $this;
    }
    /**
     * Add item to layouts value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayout $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResult
     */
    public function addToLayouts(\AfhcFacilityFinder\SForce\StructType\DescribeLayout $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayout) {
            throw new \InvalidArgumentException(sprintf('The layouts property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayout, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->layouts[] = $item;
        return $this;
    }
    /**
     * Get recordTypeMappings value
     * @return \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping[]|null
     */
    public function getRecordTypeMappings()
    {
        return $this->recordTypeMappings;
    }
    /**
     * This method is responsible for validating the values passed to the setRecordTypeMappings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecordTypeMappings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordTypeMappingsForArrayConstraintsFromSetRecordTypeMappings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutResultRecordTypeMappingsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutResultRecordTypeMappingsItem instanceof \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping) {
                $invalidValues[] = is_object($describeLayoutResultRecordTypeMappingsItem) ? get_class($describeLayoutResultRecordTypeMappingsItem) : sprintf('%s(%s)', gettype($describeLayoutResultRecordTypeMappingsItem), var_export($describeLayoutResultRecordTypeMappingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recordTypeMappings property can only contain items of type \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recordTypeMappings value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping[] $recordTypeMappings
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResult
     */
    public function setRecordTypeMappings(array $recordTypeMappings = array())
    {
        // validation for constraint: array
        if ('' !== ($recordTypeMappingsArrayErrorMessage = self::validateRecordTypeMappingsForArrayConstraintsFromSetRecordTypeMappings($recordTypeMappings))) {
            throw new \InvalidArgumentException($recordTypeMappingsArrayErrorMessage, __LINE__);
        }
        $this->recordTypeMappings = $recordTypeMappings;
        return $this;
    }
    /**
     * Add item to recordTypeMappings value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResult
     */
    public function addToRecordTypeMappings(\AfhcFacilityFinder\SForce\StructType\RecordTypeMapping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping) {
            throw new \InvalidArgumentException(sprintf('The recordTypeMappings property can only contain items of type \AfhcFacilityFinder\SForce\StructType\RecordTypeMapping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recordTypeMappings[] = $item;
        return $this;
    }
    /**
     * Get recordTypeSelectorRequired value
     * @return bool|null
     */
    public function getRecordTypeSelectorRequired()
    {
        return $this->recordTypeSelectorRequired;
    }
    /**
     * Set recordTypeSelectorRequired value
     * @param bool $recordTypeSelectorRequired
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutResult
     */
    public function setRecordTypeSelectorRequired($recordTypeSelectorRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($recordTypeSelectorRequired) && !is_bool($recordTypeSelectorRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recordTypeSelectorRequired, true), gettype($recordTypeSelectorRequired)), __LINE__);
        }
        $this->recordTypeSelectorRequired = $recordTypeSelectorRequired;
        return $this;
    }
}
