<?php

namespace AfhcFacilityFinder\SForce\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DebugLevel EnumType
 * @subpackage Enumerations
 */
class DebugLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'DebugOnly'
     * @return string 'DebugOnly'
     */
    const VALUE_DEBUG_ONLY = 'DebugOnly';
    /**
     * Constant for value 'Db'
     * @return string 'Db'
     */
    const VALUE_DB = 'Db';
    /**
     * Constant for value 'Profiling'
     * @return string 'Profiling'
     */
    const VALUE_PROFILING = 'Profiling';
    /**
     * Constant for value 'Callout'
     * @return string 'Callout'
     */
    const VALUE_CALLOUT = 'Callout';
    /**
     * Constant for value 'Detail'
     * @return string 'Detail'
     */
    const VALUE_DETAIL = 'Detail';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_DEBUG_ONLY
     * @uses self::VALUE_DB
     * @uses self::VALUE_PROFILING
     * @uses self::VALUE_CALLOUT
     * @uses self::VALUE_DETAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_DEBUG_ONLY,
            self::VALUE_DB,
            self::VALUE_PROFILING,
            self::VALUE_CALLOUT,
            self::VALUE_DETAIL,
        );
    }
}
