<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://elearning.endo7.com/webservice/soap/server.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://elearning.endo7.com/webservice/soap/server.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login($client, $username, $password) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for loginCAS operation/method
 */
if ($login->loginCAS($client, $PT, $user) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for loginLDAP operation/method
 */
if ($login->loginLDAP($client, $username, $password) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for loginStudipUser operation/method
 */
if ($login->loginStudipUser($sid, $user_id) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout($sid) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \ServiceType\Lookup($options);
/**
 * Sample call for lookupUser operation/method
 */
if ($lookup->lookupUser($sid, $user_name) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getUser operation/method
 */
if ($get->getUser($sid, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCourseXML operation/method
 */
if ($get->getCourseXML($sid, $course_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjIdByImportId operation/method
 */
if ($get->getObjIdByImportId($sid, $import_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRefIdsByImportId operation/method
 */
if ($get->getRefIdsByImportId($sid, $import_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRefIdsByObjId operation/method
 */
if ($get->getRefIdsByObjId($sid, $obj_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectByReference operation/method
 */
if ($get->getObjectByReference($sid, $reference_id, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectsByTitle operation/method
 */
if ($get->getObjectsByTitle($sid, $title, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTreeChilds operation/method
 */
if ($get->getTreeChilds($sid, $ref_id, $types, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getXMLTree operation/method
 */
if ($get->getXMLTree($sid, $ref_id, $types, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOperations operation/method
 */
if ($get->getOperations($sid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLocalRoles operation/method
 */
if ($get->getLocalRoles($sid, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserRoles operation/method
 */
if ($get->getUserRoles($sid, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectTreeOperations operation/method
 */
if ($get->getObjectTreeOperations($sid, $ref_id, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroup operation/method
 */
if ($get->getGroup($sid, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getQuestionSolution operation/method
 */
if ($get->getQuestionSolution($sid, $active_id, $question_id, $pass) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTestUserData operation/method
 */
if ($get->getTestUserData($sid, $active_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPositionOfQuestion operation/method
 */
if ($get->getPositionOfQuestion($sid, $active_id, $question_id, $pass) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPreviousReachedPoints operation/method
 */
if ($get->getPreviousReachedPoints($sid, $active_id, $question_id, $pass) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNrOfQuestionsInPass operation/method
 */
if ($get->getNrOfQuestionsInPass($sid, $active_id, $pass) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStructureObjects operation/method
 */
if ($get->getStructureObjects($sid, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoles operation/method
 */
if ($get->getRoles($sid, $role_type, $id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUsersForContainer operation/method
 */
if ($get->getUsersForContainer($sid, $ref_id, $attach_roles, $active) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUsersForRole operation/method
 */
if ($get->getUsersForRole($sid, $role_id, $attach_roles, $active) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNIC operation/method
 */
if ($get->getNIC($sid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExerciseXML operation/method
 */
if ($get->getExerciseXML($sid, $ref_id, $attachment_mode) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFileXML operation/method
 */
if ($get->getFileXML($sid, $ref_id, $attachment_mode) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserXML operation/method
 */
if ($get->getUserXML($sid, $user_ids, $attach_roles) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjIdsByRefIds operation/method
 */
if ($get->getObjIdsByRefIds($sid, $ref_ids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIMSManifestXML operation/method
 */
if ($get->getIMSManifestXML($sid, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSCORMCompletionStatus operation/method
 */
if ($get->getSCORMCompletionStatus($sid, $usr_id, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTestResults operation/method
 */
if ($get->getTestResults($sid, $ref_id, $sum_only) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCoursesForUser operation/method
 */
if ($get->getCoursesForUser($sid, $parameters) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroupsForUser operation/method
 */
if ($get->getGroupsForUser($sid, $parameters) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPathForRefId operation/method
 */
if ($get->getPathForRefId($sid, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInstallationInfoXML operation/method
 */
if ($get->getInstallationInfoXML() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClientInfoXML operation/method
 */
if ($get->getClientInfoXML($clientid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSkillCompletionDateForTriggerRefId operation/method
 */
if ($get->getSkillCompletionDateForTriggerRefId($sid, $user_id, $ref_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSkillTriggerOfAllCertificates operation/method
 */
if ($get->getSkillTriggerOfAllCertificates($sid, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserIdBySid operation/method
 */
if ($get->getUserIdBySid($sid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLearningProgressChanges operation/method
 */
if ($get->getLearningProgressChanges($sid, $timestamp, $include_ref_ids, $type_filter) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProgressInfo operation/method
 */
if ($get->getProgressInfo($sid, $ref_id, $progress_filter) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteUser operation/method
 */
if ($delete->deleteUser($sid, $user_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteCourse operation/method
 */
if ($delete->deleteCourse($sid, $course_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteObject operation/method
 */
if ($delete->deleteObject($sid, $reference_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteUserRoleEntry operation/method
 */
if ($delete->deleteUserRoleEntry($sid, $user_id, $role_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteRole operation/method
 */
if ($delete->deleteRole($sid, $role_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteExpiredDualOptInUserObjects operation/method
 */
if ($delete->deleteExpiredDualOptInUserObjects($sid, $usr_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteProgress operation/method
 */
if ($delete->deleteProgress($sid, $ref_ids, $usr_ids, $type_filter, $progress_filter) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addCourse operation/method
 */
if ($add->addCourse($sid, $target_id, $crs_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addObject operation/method
 */
if ($add->addObject($sid, $target_id, $object_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addReference operation/method
 */
if ($add->addReference($sid, $source_id, $target_id) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addUserRoleEntry operation/method
 */
if ($add->addUserRoleEntry($sid, $user_id, $role_id) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRole operation/method
 */
if ($add->addRole($sid, $target_id, $obj_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRoleFromTemplate operation/method
 */
if ($add->addRoleFromTemplate($sid, $target_id, $obj_xml, $role_template_id) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGroup operation/method
 */
if ($add->addGroup($sid, $target_id, $group_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addExercise operation/method
 */
if ($add->addExercise($sid, $target_id, $xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFile operation/method
 */
if ($add->addFile($sid, $target_id, $xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
/**
 * Sample call for assignCourseMember operation/method
 */
if ($assign->assignCourseMember($sid, $course_id, $user_id, $type) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Sample call for assignGroupMember operation/method
 */
if ($assign->assignGroupMember($sid, $group_id, $user_id, $type) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Exclude ServiceType
 */
$exclude = new \ServiceType\Exclude($options);
/**
 * Sample call for excludeCourseMember operation/method
 */
if ($exclude->excludeCourseMember($sid, $course_id, $user_id) !== false) {
    print_r($exclude->getResult());
} else {
    print_r($exclude->getLastError());
}
/**
 * Sample call for excludeGroupMember operation/method
 */
if ($exclude->excludeGroupMember($sid, $group_id, $user_id) !== false) {
    print_r($exclude->getResult());
} else {
    print_r($exclude->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for isAssignedToCourse operation/method
 */
if ($is->isAssignedToCourse($sid, $course_id, $user_id) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isAssignedToGroup operation/method
 */
if ($is->isAssignedToGroup($sid, $group_id, $user_id) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateCourse operation/method
 */
if ($update->updateCourse($sid, $course_id, $xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateObjects operation/method
 */
if ($update->updateObjects($sid, $object_xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateExercise operation/method
 */
if ($update->updateExercise($sid, $ref_id, $xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFile operation/method
 */
if ($update->updateFile($sid, $ref_id, $xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGroup operation/method
 */
if ($update->updateGroup($sid, $ref_id, $xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateWebLink operation/method
 */
if ($update->updateWebLink($sid, $ref_id, $xml) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for searchObjects operation/method
 */
if ($search->searchObjects($sid, $types, $key, $combination, $user_id) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchUser operation/method
 */
if ($search->searchUser($sid, $key_fields, $query_operator, $key_values, $attach_roles, $active) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchRoles operation/method
 */
if ($search->searchRoles($sid, $key, $combination, $role_type) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeFromSystemByImportId operation/method
 */
if ($remove->removeFromSystemByImportId($sid, $import_id) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTestResults operation/method
 */
if ($remove->removeTestResults($sid, $ref_id, $user_ids) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Revoke ServiceType
 */
$revoke = new \ServiceType\Revoke($options);
/**
 * Sample call for revokePermissions operation/method
 */
if ($revoke->revokePermissions($sid, $ref_id, $role_id) !== false) {
    print_r($revoke->getResult());
} else {
    print_r($revoke->getLastError());
}
/**
 * Samples for Grant ServiceType
 */
$grant = new \ServiceType\Grant($options);
/**
 * Sample call for grantPermissions operation/method
 */
if ($grant->grantPermissions($sid, $ref_id, $role_id, $operations) !== false) {
    print_r($grant->getResult());
} else {
    print_r($grant->getLastError());
}
/**
 * Samples for Group ServiceType
 */
$group = new \ServiceType\Group($options);
/**
 * Sample call for groupExists operation/method
 */
if ($group->groupExists($sid, $title) !== false) {
    print_r($group->getResult());
} else {
    print_r($group->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendMail operation/method
 */
if ($send->sendMail($sid, $rcp_to, $rcp_cc, $rcp_bcc, $sender, $subject, $message, $attachments) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Distribute ServiceType
 */
$distribute = new \ServiceType\Distribute($options);
/**
 * Sample call for distributeMails operation/method
 */
if ($distribute->distributeMails($sid, $mail_xml) !== false) {
    print_r($distribute->getResult());
} else {
    print_r($distribute->getLastError());
}
/**
 * Samples for Il ServiceType
 */
$il = new \ServiceType\Il($options);
/**
 * Sample call for ilClone operation/method
 */
if ($il->ilClone($sid, $copy_identifier) !== false) {
    print_r($il->getResult());
} else {
    print_r($il->getLastError());
}
/**
 * Sample call for ilCloneDependencies operation/method
 */
if ($il->ilCloneDependencies($sid, $copy_identifier) !== false) {
    print_r($il->getResult());
} else {
    print_r($il->getLastError());
}
/**
 * Samples for Handle ServiceType
 */
$handle = new \ServiceType\Handle($options);
/**
 * Sample call for handleECSTasks operation/method
 */
if ($handle->handleECSTasks($sid, $server_id) !== false) {
    print_r($handle->getResult());
} else {
    print_r($handle->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for saveQuestionResult operation/method
 */
if ($save->saveQuestionResult($sid, $user_id, $test_id, $question_id, $pass, $solution) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveQuestion operation/method
 */
if ($save->saveQuestion($sid, $active_id, $question_id, $pass, $solution) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveQuestionSolution operation/method
 */
if ($save->saveQuestionSolution($sid, $active_id, $question_id, $pass, $solution) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for importUsers operation/method
 */
if ($import->importUsers($sid, $folder_id, $usr_xml, $conflict_rule, $send_account_mail) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \ServiceType\Has($options);
/**
 * Sample call for hasNewMail operation/method
 */
if ($has->hasNewMail($sid) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Sample call for hasSCORMCertificate operation/method
 */
if ($has->hasSCORMCertificate($sid, $ref_id, $usr_id) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \ServiceType\Copy($options);
/**
 * Sample call for copyObject operation/method
 */
if ($copy->copyObject($sid, $xml) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
/**
 * Sample call for moveObject operation/method
 */
if ($move->moveObject($sid, $ref_id, $target_id) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkSkillUserCertificateForTriggerRefId operation/method
 */
if ($check->checkSkillUserCertificateForTriggerRefId($sid, $user_id, $ref_id) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
/**
 * Sample call for readWebLink operation/method
 */
if ($read->readWebLink($sid, $ref_id) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createWebLink operation/method
 */
if ($create->createWebLink($sid, $target_id, $xml) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Export ServiceType
 */
$export = new \ServiceType\Export($options);
/**
 * Sample call for exportDataCollectionContent operation/method
 */
if ($export->exportDataCollectionContent($sid, $ref_id, $table_id, $format, $filepath) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for processBackgroundTask operation/method
 */
if ($process->processBackgroundTask($sid, $task_id) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
