<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ilOperation StructType
 * @subpackage Structs
 */
class IlOperation extends AbstractStructBase
{
    /**
     * The ops_id
     * @var int
     */
    public $ops_id;
    /**
     * The operation
     * @var string
     */
    public $operation;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * Constructor method for ilOperation
     * @uses IlOperation::setOps_id()
     * @uses IlOperation::setOperation()
     * @uses IlOperation::setDescription()
     * @param int $ops_id
     * @param string $operation
     * @param string $description
     */
    public function __construct($ops_id = null, $operation = null, $description = null)
    {
        $this
            ->setOps_id($ops_id)
            ->setOperation($operation)
            ->setDescription($description);
    }
    /**
     * Get ops_id value
     * @return int|null
     */
    public function getOps_id()
    {
        return $this->ops_id;
    }
    /**
     * Set ops_id value
     * @param int $ops_id
     * @return \StructType\IlOperation
     */
    public function setOps_id($ops_id = null)
    {
        // validation for constraint: int
        if (!is_null($ops_id) && !is_numeric($ops_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ops_id)), __LINE__);
        }
        $this->ops_id = $ops_id;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \StructType\IlOperation
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\IlOperation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IlOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
