<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateCourse
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateCourse(). Update course settings, assigned members, tutors, administrators with a given xml description
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @param string $xml
     * @return boolean|bool
     */
    public function updateCourse($sid, $course_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCourse($sid, $course_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateObjects
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateObjects. Update object data (title,description,owner)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $object_xml
     * @return boolean|bool
     */
    public function updateObjects($sid, $object_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateObjects($sid, $object_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateExercise
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateExercise():update existing exercise, update exercise properties from xml (see ilias_exercise_3_8.dtd for details). obj_id in xml must match according obj id of refid.!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $xml
     * @return boolean|bool
     */
    public function updateExercise($sid, $ref_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateExercise($sid, $ref_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFile
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateFile():update existing file, update file properties from xml (see ilias_file_3_8.dtd for details). obj_id in xml must match according obj id of refid.!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $xml
     * @return boolean|bool
     */
    public function updateFile($sid, $ref_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFile($sid, $ref_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGroup
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateGroup(): update existing group using ref id and group xml (see DTD).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $xml
     * @return boolean|bool
     */
    public function updateGroup($sid, $ref_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGroup($sid, $ref_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWebLink
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS updateWebLink():update existing weblink, update weblink properties from xml (see ilias_weblink_4_0.dtd for details).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $xml
     * @return boolean|bool
     */
    public function updateWebLink($sid, $ref_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->updateWebLink($sid, $ref_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
