<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendMail
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS sendMail(): Send mime mails according to xml description. Only for internal usage Syntax, parameters may change in future releases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $rcp_to
     * @param string $rcp_cc
     * @param string $rcp_bcc
     * @param string $sender
     * @param string $subject
     * @param string $message
     * @param string $attachments
     * @return boolean|bool
     */
    public function sendMail($sid, $rcp_to, $rcp_cc, $rcp_bcc, $sender, $subject, $message, $attachments)
    {
        try {
            $this->setResult(self::getSoapClient()->sendMail($sid, $rcp_to, $rcp_cc, $rcp_bcc, $sender, $subject, $message, $attachments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
