<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeFromSystemByImportId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS removeFromSystemByImportId(). Removes an object identified by its import id permanently from the system. All data will be deleted. There will be no possibility to restore it from the trash. Do not use this function for deleting
     * roles or users. Use deleteUser() or deleteRole() instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $import_id
     * @return boolean|bool
     */
    public function removeFromSystemByImportId($sid, $import_id)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFromSystemByImportId($sid, $import_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTestResults
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS removeTestResults(): remove test results for the chosen users
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $user_ids
     * @return boolean|bool
     */
    public function removeTestResults($sid, $ref_id, $user_ids)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTestResults($sid, $ref_id, $user_ids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
