<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Il ServiceType
 * @subpackage Services
 */
class Il extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ilClone
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS ilClone(): Only for internal usage.Syntax, parameters may change in future releases.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $copy_identifier
     * @return int|bool
     */
    public function ilClone($sid, $copy_identifier)
    {
        try {
            $this->setResult(self::getSoapClient()->ilClone($sid, $copy_identifier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ilCloneDependencies
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS ilCloneDependencies(): Only for internal usage.Syntax, parameters may change in future releases.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $copy_identifier
     * @return boolean|bool
     */
    public function ilCloneDependencies($sid, $copy_identifier)
    {
        try {
            $this->setResult(self::getSoapClient()->ilCloneDependencies($sid, $copy_identifier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
