<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Handle ServiceType
 * @subpackage Services
 */
class Handle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named handleECSTasks
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS handleECSTasks(): Only for internal usage.Syntax, parameters may change in future releases.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $server_id
     * @return boolean|bool
     */
    public function handleECSTasks($sid, $server_id)
    {
        try {
            $this->setResult(self::getSoapClient()->handleECSTasks($sid, $server_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
