<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exclude ServiceType
 * @subpackage Services
 */
class Exclude extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named excludeCourseMember
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS excludeCourseMember(). Excludes an user from an existing course.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @param string $user_id
     * @return boolean|bool
     */
    public function excludeCourseMember($sid, $course_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->excludeCourseMember($sid, $course_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named excludeGroupMember
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS excludeGroupMember(). Excludes an user from an existing group.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $group_id
     * @param string $user_id
     * @return boolean|bool
     */
    public function excludeGroupMember($sid, $group_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->excludeGroupMember($sid, $group_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
