<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteUser(). Deletes all user related data (Bookmarks, Mails ...). DEPRECATED: Use importUsers() for deletion of user data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @return boolean|bool
     */
    public function deleteUser($sid, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteUser($sid, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteCourse
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteCourse(). Deletes a course. Delete courses are stored in "Trash" and can be undeleted in the ILIAS administration.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @return boolean|bool
     */
    public function deleteCourse($sid, $course_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCourse($sid, $course_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteObject
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteObject. Stores object in trash. If multiple references exist, only the reference is deleted
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $reference_id
     * @return boolean|bool
     */
    public function deleteObject($sid, $reference_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteObject($sid, $reference_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteUserRoleEntry
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteUserRoleEntry. Deassign user from role.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @param string $role_id
     * @return boolean|bool
     */
    public function deleteUserRoleEntry($sid, $user_id, $role_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteUserRoleEntry($sid, $user_id, $role_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteRole
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteRole(): Deletes an role and all user assignments. Fails if it is the last role of an user
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $role_id
     * @return boolean|bool
     */
    public function deleteRole($sid, $role_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteRole($sid, $role_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteExpiredDualOptInUserObjects
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS deleteExpiredDualOptInUserObjects(): Deletes expired user accounts caused by unconfirmed registration links in "dual opt in" registration method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $usr_id
     * @return boolean|bool
     */
    public function deleteExpiredDualOptInUserObjects($sid, $usr_id)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteExpiredDualOptInUserObjects($sid, $usr_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteProgress
     * Meta informations extracted from the WSDL
     * - documentation: Delete user progress data of objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_ids
     * @param string $usr_ids
     * @param string $type_filter
     * @param string $progress_filter
     * @return boolean|bool
     */
    public function deleteProgress($sid, $ref_ids, $usr_ids, $type_filter, $progress_filter)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteProgress($sid, $ref_ids, $usr_ids, $type_filter, $progress_filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
