<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assign ServiceType
 * @subpackage Services
 */
class Assign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named assignCourseMember
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS assignCourseMember(). Assigns an user to an existing course. Type should be "Admin", "Tutor" or "Member"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @param string $user_id
     * @param string $type
     * @return boolean|bool
     */
    public function assignCourseMember($sid, $course_id, $user_id, $type)
    {
        try {
            $this->setResult(self::getSoapClient()->assignCourseMember($sid, $course_id, $user_id, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named assignGroupMember
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS assignGroupMember(). Assigns an user to an existing group. Type should be "Admin","Member"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $group_id
     * @param string $user_id
     * @param string $type
     * @return boolean|bool
     */
    public function assignGroupMember($sid, $group_id, $user_id, $type)
    {
        try {
            $this->setResult(self::getSoapClient()->assignGroupMember($sid, $group_id, $user_id, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
