<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchObjects
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS searchObjects(): Searches for objects. Key is within "title" or "description" Typical calls are searchObject($sid,array("lm","crs"),"\"this and that\"","and"); If an optional user id is given, this methods also return the
     * permissions for that user on the found objects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $types
     * @param string $key
     * @param string $combination
     * @param string $user_id
     * @return string|bool
     */
    public function searchObjects($sid, $types, $key, $combination, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->searchObjects($sid, $types, $key, $combination, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS searchUser(): get all users, which match a query, consisting of the keyfields, matched with values of the field values, concatenated with the logical query operator. Specify attach_roles to 1, to attach all role assignmnents;
     * specify active: 1, to import active only, 0: inactive only, -1: both
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $key_fields
     * @param string $query_operator
     * @param string $key_values
     * @param string $attach_roles
     * @param string $active
     * @return string|bool
     */
    public function searchUser($sid, $key_fields, $query_operator, $key_values, $attach_roles, $active)
    {
        try {
            $this->setResult(self::getSoapClient()->searchUser($sid, $key_fields, $query_operator, $key_values, $attach_roles, $active));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRoles
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS searchRoles(): returns XML following role dtd with search results for given role type and search terms.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $key
     * @param string $combination
     * @param string $role_type
     * @return string|bool
     */
    public function searchRoles($sid, $key, $combination, $role_type)
    {
        try {
            $this->setResult(self::getSoapClient()->searchRoles($sid, $key, $combination, $role_type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
