<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named saveQuestionResult
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS saveQuesionResult: Typically called from an external assessment question to save the user input. DEPRECATED since ILIAS 3.9
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @param string $test_id
     * @param string $question_id
     * @param string $pass
     * @param string $solution
     * @return boolean|bool
     */
    public function saveQuestionResult($sid, $user_id, $test_id, $question_id, $pass, $solution)
    {
        try {
            $this->setResult(self::getSoapClient()->saveQuestionResult($sid, $user_id, $test_id, $question_id, $pass, $solution));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveQuestion
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS saveQuestion: Saves the result of a question in a given test pass for the active test user. The active user is identified by the active ID, which assigns a user to a test.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $question_id
     * @param string $pass
     * @param string $solution
     * @return boolean|bool
     */
    public function saveQuestion($sid, $active_id, $question_id, $pass, $solution)
    {
        try {
            $this->setResult(self::getSoapClient()->saveQuestion($sid, $active_id, $question_id, $pass, $solution));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveQuestionSolution
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS saveQuestionSolution: Saves the result of a question in a given test pass for the active test user. The active user is identified by the active ID, which assigns a user to a test. The solution has to be an XML string which
     * contains &lt;values&gt;&lt;value&gt;VALUE&lt;/value&gt;&lt;value&gt;VALUE&lt;/value&gt;&lt;points&gt;POINTS&lt;/points&gt;...&lt;/values&gt; where the triplet (value,value,points) can repeat n times. The result string is either TRUE or it contains an
     * error message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $question_id
     * @param string $pass
     * @param string $solution
     * @return string|bool
     */
    public function saveQuestionSolution($sid, $active_id, $question_id, $pass, $solution)
    {
        try {
            $this->setResult(self::getSoapClient()->saveQuestionSolution($sid, $active_id, $question_id, $pass, $solution));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
