<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Revoke ServiceType
 * @subpackage Services
 */
class Revoke extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named revokePermissions
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS revokePermissions(): Revoke all permissions for a specific role on an object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $role_id
     * @return boolean|bool
     */
    public function revokePermissions($sid, $ref_id, $role_id)
    {
        try {
            $this->setResult(self::getSoapClient()->revokePermissions($sid, $ref_id, $role_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
