<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lookup ServiceType
 * @subpackage Services
 */
class Lookup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lookupUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS lookupUser(): check if username exists. Return usr_id or 0 if lookup fails.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_name
     * @return int|bool
     */
    public function lookupUser($sid, $user_name)
    {
        try {
            $this->setResult(self::getSoapClient()->lookupUser($sid, $user_name));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
