<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named login
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS login function
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $client
     * @param string $username
     * @param string $password
     * @return string|bool
     */
    public function login($client, $username, $password)
    {
        try {
            $this->setResult(self::getSoapClient()->login($client, $username, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named loginCAS
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS login function via CAS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $client
     * @param string $pT
     * @param string $user
     * @return string|bool
     */
    public function loginCAS($client, $pT, $user)
    {
        try {
            $this->setResult(self::getSoapClient()->loginCAS($client, $pT, $user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named loginLDAP
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS login function via LDAP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $client
     * @param string $username
     * @param string $password
     * @return string|bool
     */
    public function loginLDAP($client, $username, $password)
    {
        try {
            $this->setResult(self::getSoapClient()->loginLDAP($client, $username, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named loginStudipUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS login function for Stud.IP-Connection. DEPRECATED: this method will be removed in ILIAS 5.3.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @return string|bool
     */
    public function loginStudipUser($sid, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->loginStudipUser($sid, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
