<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isAssignedToCourse
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS isAssignedToCourse(). Checks whether an user is assigned to a given course. Returns 0 => not assigned, 1 => course admin, 2 => course member or 3 => course tutor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @param string $user_id
     * @return int|bool
     */
    public function isAssignedToCourse($sid, $course_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->isAssignedToCourse($sid, $course_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isAssignedToGroup
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS isAssignedToGroup(). Checks whether an user is assigned to a given group. Returns 0 => not assigned, 1 => group admin, 2 => group member
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $group_id
     * @param string $user_id
     * @return int|bool
     */
    public function isAssignedToGroup($sid, $group_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->isAssignedToGroup($sid, $group_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
