<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Has ServiceType
 * @subpackage Services
 */
class Has extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hasNewMail
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS hasNewMail(): Checks whether the current authenticated user has a new mail.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @return boolean|bool
     */
    public function hasNewMail($sid)
    {
        try {
            $this->setResult(self::getSoapClient()->hasNewMail($sid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hasSCORMCertificate
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS hasSCORMCertificate(): returns true if a certficate is available for a user referred by usr_id in a SCORM learning module referred by ref_id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $usr_id
     * @return boolean|bool
     */
    public function hasSCORMCertificate($sid, $ref_id, $usr_id)
    {
        try {
            $this->setResult(self::getSoapClient()->hasSCORMCertificate($sid, $ref_id, $usr_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
