<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grant ServiceType
 * @subpackage Services
 */
class Grant extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named grantPermissions
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS grantPermissions(): Grant permissions for a specific role on an object. (Substitutes existing permission settings)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $role_id
     * @param string $operations
     * @return boolean|bool
     */
    public function grantPermissions($sid, $ref_id, $role_id, $operations)
    {
        try {
            $this->setResult(self::getSoapClient()->grantPermissions($sid, $ref_id, $role_id, $operations));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
