<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUser(): get complete set of user data. DEPRECATED with release 5.2, will be deleted with 5.3. Use searchUsers() instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @return \StructType\IlUserData|bool
     */
    public function getUser($sid, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getUser($sid, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCourseXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getCourseXML(). Get a xml description of a specific course.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $course_id
     * @return string|bool
     */
    public function getCourseXML($sid, $course_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getCourseXML($sid, $course_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjIdByImportId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getObjIdByImportId(). Get the obj_id of an ILIAS obj by a given import id.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $import_id
     * @return int|bool
     */
    public function getObjIdByImportId($sid, $import_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getObjIdByImportId($sid, $import_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRefIdsByImportId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getRefIdsByImportId(). Get all reference ids by a given import id.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $import_id
     * @return int[]|bool
     */
    public function getRefIdsByImportId($sid, $import_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRefIdsByImportId($sid, $import_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRefIdsByObjId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getRefIdsByObjId(). Get all reference ids by a given object id.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $obj_id
     * @return int[]|bool
     */
    public function getRefIdsByObjId($sid, $obj_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRefIdsByObjId($sid, $obj_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectByReference
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getObjectByReference(). Get XML-description of an ILIAS object. If a user id is given, this methods also checks the permissions of that user on the object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $reference_id
     * @param string $user_id
     * @return string|bool
     */
    public function getObjectByReference($sid, $reference_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getObjectByReference($sid, $reference_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectsByTitle
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getObjectsByTitle(). Get XML-description of an ILIAS object with given title. If a user id is given this method also checks the permissions of that user on the object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $title
     * @param string $user_id
     * @return string|bool
     */
    public function getObjectsByTitle($sid, $title, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getObjectsByTitle($sid, $title, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTreeChilds
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getTreeChilds(): Get all child objects of a given object.Choose array of types to filter the output. Choose empty type array to receive all object types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $types
     * @param string $user_id
     * @return string|bool
     */
    public function getTreeChilds($sid, $ref_id, $types, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getTreeChilds($sid, $ref_id, $types, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getXMLTree
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getXMLTree(): Returns a xml stream with the subtree objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $types
     * @param string $user_id
     * @return string|bool
     */
    public function getXMLTree($sid, $ref_id, $types, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getXMLTree($sid, $ref_id, $types, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOperations
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getOperations(): get complete set of RBAC operations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @return ilOperations|bool
     */
    public function getOperations($sid)
    {
        try {
            $this->setResult(self::getSoapClient()->getOperations($sid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocalRoles
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getLocalRoles(): Get all local roles assigned to an specific object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @return string|bool
     */
    public function getLocalRoles($sid, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getLocalRoles($sid, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserRoles
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUserRoles(): Get all local roles assigned to an specific user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @return string|bool
     */
    public function getUserRoles($sid, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserRoles($sid, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectTreeOperations
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getObjectTreeOperations(): Get all granted permissions for all references of an object for a specific user. Returns array of granted operations or empty array
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $user_id
     * @return ilOperations|bool
     */
    public function getObjectTreeOperations($sid, $ref_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getObjectTreeOperations($sid, $ref_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroup
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getGroup(): get xml description of grouip with given reference id.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @return string|bool
     */
    public function getGroup($sid, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getGroup($sid, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getQuestionSolution
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getQuestionSolution: Typically called from external assessment questions to retrieve the previous input of a user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $question_id
     * @param string $pass
     * @return string[]|bool
     */
    public function getQuestionSolution($sid, $active_id, $question_id, $pass)
    {
        try {
            $this->setResult(self::getSoapClient()->getQuestionSolution($sid, $active_id, $question_id, $pass));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTestUserData
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getTestUserData: Typically called from external assessment questions to retrieve data of the active user. The returned string array values are fullname, title, firstname, lastname, login.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @return string[]|bool
     */
    public function getTestUserData($sid, $active_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getTestUserData($sid, $active_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPositionOfQuestion
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getPositionOfQuestion: Returns the position of a given question for a given user in a given test pass.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $question_id
     * @param string $pass
     * @return int|bool
     */
    public function getPositionOfQuestion($sid, $active_id, $question_id, $pass)
    {
        try {
            $this->setResult(self::getSoapClient()->getPositionOfQuestion($sid, $active_id, $question_id, $pass));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPreviousReachedPoints
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getPreviousReachedPoints: Returns an array of reached points for the previous questions in a given test pass.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $question_id
     * @param string $pass
     * @return double[]|bool
     */
    public function getPreviousReachedPoints($sid, $active_id, $question_id, $pass)
    {
        try {
            $this->setResult(self::getSoapClient()->getPreviousReachedPoints($sid, $active_id, $question_id, $pass));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNrOfQuestionsInPass
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getNrOfQuestionsInPass: Returns the question count for a given test user in a given pass.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $active_id
     * @param string $pass
     * @return int|bool
     */
    public function getNrOfQuestionsInPass($sid, $active_id, $pass)
    {
        try {
            $this->setResult(self::getSoapClient()->getNrOfQuestionsInPass($sid, $active_id, $pass));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStructureObjects
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getStructureObjects: delivers structure of content objects like learning modules (chapters/pages) or glossary (terms)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @return string|bool
     */
    public function getStructureObjects($sid, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getStructureObjects($sid, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoles
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getRoles():if id equals -1, get all roles specified by type (global|local|user|user_login|template or empty), if type is empty all roles with all types are delivered, if id > -1 and role_type <> user or user_login, delivers all
     * roles which belong to a repository object with specified ref_id, if roletype is user a numeric id is interpreted as userid, if roletype is user_login it is interpreted as login,if roletype is template all role templates will be listed
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $role_type
     * @param string $id
     * @return string|bool
     */
    public function getRoles($sid, $role_type, $id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoles($sid, $role_type, $id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUsersForContainer
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUsersForContainer(): get all users of a specific ref_id, which can be crs, group, category or user folder (value: -1). Choose if all roles of a user should be attached (1) or not (0). set active to -1 to get all, 0, to get
     * inactive users only, 1 to get active users only
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $attach_roles
     * @param string $active
     * @return string|bool
     */
    public function getUsersForContainer($sid, $ref_id, $attach_roles, $active)
    {
        try {
            $this->setResult(self::getSoapClient()->getUsersForContainer($sid, $ref_id, $attach_roles, $active));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUsersForRole
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUsersForRole(): get all users of a role with specified id, specify attach_roles to 1, to attach all role assignmnents; specify active: 1, to import active only, 0: inactive only, -1: both
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $role_id
     * @param string $attach_roles
     * @param string $active
     * @return string|bool
     */
    public function getUsersForRole($sid, $role_id, $attach_roles, $active)
    {
        try {
            $this->setResult(self::getSoapClient()->getUsersForRole($sid, $role_id, $attach_roles, $active));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNIC
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getNIC(): DEPRECATED: use getClientInfoXML instead. was: return client information from current client as xml result set containing installation_id, installation_version, installation_url, installation_description,
     * installation_language_default as columns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @return string|bool
     */
    public function getNIC($sid)
    {
        try {
            $this->setResult(self::getSoapClient()->getNIC($sid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExerciseXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getExerciseXML(): returns xml description of exercise. Attachment mode: 0 - no file contents, 1 - plain content (base64encoded), 2 zlib + base64, 3 gzip + base64)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $attachment_mode
     * @return string|bool
     */
    public function getExerciseXML($sid, $ref_id, $attachment_mode)
    {
        try {
            $this->setResult(self::getSoapClient()->getExerciseXML($sid, $ref_id, $attachment_mode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFileXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getFileXML(): returns xml description of file. Attachment mode: 0 - no file contents, 1 - plain content (base64encoded), 2 zlib + base64, 3 gzip + base64)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $attachment_mode
     * @return string|bool
     */
    public function getFileXML($sid, $ref_id, $attachment_mode)
    {
        try {
            $this->setResult(self::getSoapClient()->getFileXML($sid, $ref_id, $attachment_mode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUserXML(): get xml records for user ids, e.g. retrieved vom members of course xml. Returns user xml dtds. ids are numeric ids of user
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_ids
     * @param string $attach_roles
     * @return string|bool
     */
    public function getUserXML($sid, $user_ids, $attach_roles)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserXML($sid, $user_ids, $attach_roles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjIdsByRefIds
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getObjIdsForRefIds: Returns a array of object ids which match the references id, given by a comma seperated string. Returns an array of ref ids, in the same order as object ids. Therefore, there might by duplicates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_ids
     * @return int[]|bool
     */
    public function getObjIdsByRefIds($sid, $ref_ids)
    {
        try {
            $this->setResult(self::getSoapClient()->getObjIdsByRefIds($sid, $ref_ids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIMSManifestXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getIMSManifestXML(): returns xml of ims manifest file (scorm learning module) referred by refid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @return string|bool
     */
    public function getIMSManifestXML($sid, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getIMSManifestXML($sid, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSCORMCompletionStatus
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getSCORMCompletionStatus(): returns a completion status of a scorm module
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $usr_id
     * @param string $ref_id
     * @return string|bool
     */
    public function getSCORMCompletionStatus($sid, $usr_id, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getSCORMCompletionStatus($sid, $usr_id, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTestResults
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getTestResults(): returns XMLResultSet with sum only = true: user_id, login, firstname, lastname, matriculation, maximum points, received points sum only = false: user_id, login, firstname, lastname, matriculation, question id,
     * question title, question points, received points
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $sum_only
     * @return string|bool
     */
    public function getTestResults($sid, $ref_id, $sum_only)
    {
        try {
            $this->setResult(self::getSoapClient()->getTestResults($sid, $ref_id, $sum_only));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCoursesForUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getTestResults(): returns XMLResultSet with columns ref_id, course xml. $parameters has to contain a column user_id and a column status. Status is a logical AND combined value of (MEMBER = 1, TUTOR = 2, ADMIN = 4, OWNER = 8)
     * and determines which courses should be returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $parameters
     * @return string|bool
     */
    public function getCoursesForUser($sid, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCoursesForUser($sid, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupsForUser
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getTestResults(): returns XMLResultSet with columns ref_id, group xml. $parameters has to contain a column user_id and a column status. Status is a logical AND combined value of (MEMBER = 1, TUTOR = 2, OWNER = 4) and determines
     * which groups should be returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $parameters
     * @return string|bool
     */
    public function getGroupsForUser($sid, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getGroupsForUser($sid, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPathForRefId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getPathForRefId(): returns XMLResultSet with columns ref_id, type and title.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @return string|bool
     */
    public function getPathForRefId($sid, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getPathForRefId($sid, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInstallationInfoXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getInstallationInfoXML(): returns XML following installation_info dtd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getInstallationInfoXML()
    {
        try {
            $this->setResult(self::getSoapClient()->getInstallationInfoXML());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientInfoXML
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getClientInfoXML(): returns XML following installation_info dtd, contains the client the data of given client id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $clientid
     * @return string|bool
     */
    public function getClientInfoXML($clientid)
    {
        try {
            $this->setResult(self::getSoapClient()->getClientInfoXML($clientid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getSkillCompletionDateForTriggerRefId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getSkillCompletionDateForTriggerRefId(). Get completion dates for skill trigger ref ids.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @param string $ref_id
     * @return string|bool
     */
    public function getSkillCompletionDateForTriggerRefId($sid, $user_id, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getSkillCompletionDateForTriggerRefId($sid, $user_id, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSkillTriggerOfAllCertificates
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getSkillTriggerOfAllCertificates(). Check get all trigger with certificate for a user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @return string|bool
     */
    public function getSkillTriggerOfAllCertificates($sid, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getSkillTriggerOfAllCertificates($sid, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserIdBySid
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getUserIdBySid(): returns an ILIAS usr_id for the given sid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @return int|bool
     */
    public function getUserIdBySid($sid)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserIdBySid($sid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLearningProgressChanges
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS getLearningProgressChanges(): Get learning progress changes after a given timestamp.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $timestamp
     * @param string $include_ref_ids
     * @param string $type_filter
     * @return string|bool
     */
    public function getLearningProgressChanges($sid, $timestamp, $include_ref_ids, $type_filter)
    {
        try {
            $this->setResult(self::getSoapClient()->getLearningProgressChanges($sid, $timestamp, $include_ref_ids, $type_filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProgressInfo
     * Meta informations extracted from the WSDL
     * - documentation: Get object learning progress information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $progress_filter
     * @return string|bool
     */
    public function getProgressInfo($sid, $ref_id, $progress_filter)
    {
        try {
            $this->setResult(self::getSoapClient()->getProgressInfo($sid, $ref_id, $progress_filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return double[]|ilOperations|int|int[]|string|string[]|\StructType\IlUserData
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
