<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Export ServiceType
 * @subpackage Services
 */
class Export extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named exportDataCollectionContent
     * Meta informations extracted from the WSDL
     * - documentation: Generate DataCollectionContent Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $ref_id
     * @param string $table_id
     * @param string $format
     * @param string $filepath
     * @return string|bool
     */
    public function exportDataCollectionContent($sid, $ref_id, $table_id, $format, $filepath)
    {
        try {
            $this->setResult(self::getSoapClient()->exportDataCollectionContent($sid, $ref_id, $table_id, $format, $filepath));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
