<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Copy ServiceType
 * @subpackage Services
 */
class Copy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named copyObject
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS copyObject(): returns reference of copy, if copy is created directly, or the ref id of the target if copy is in progress.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $xml
     * @return int|bool
     */
    public function copyObject($sid, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->copyObject($sid, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
