<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * checkSkillUserCertificateForTriggerRefId
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS checkSkillUserCertificateForTriggerRefId(). Check user certificates for trigger ref ids.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @param string $ref_id
     * @return string|bool
     */
    public function checkSkillUserCertificateForTriggerRefId($sid, $user_id, $ref_id)
    {
        try {
            $this->setResult(self::getSoapClient()->checkSkillUserCertificateForTriggerRefId($sid, $user_id, $ref_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
