<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addCourse
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addCourse(). Course import. See ilias_course_0_1.dtd for details about course xml structure
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $crs_xml
     * @return int|bool
     */
    public function addCourse($sid, $target_id, $crs_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addCourse($sid, $target_id, $crs_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addObject
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addObject. Create new object based on xml description under a given node ("category,course,group or folder). Return created reference id of the new object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $object_xml
     * @return int|bool
     */
    public function addObject($sid, $target_id, $object_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addObject($sid, $target_id, $object_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addReference
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addReference. Create new link of given object to new object. Return the new reference id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $source_id
     * @param string $target_id
     * @return int|bool
     */
    public function addReference($sid, $source_id, $target_id)
    {
        try {
            $this->setResult(self::getSoapClient()->addReference($sid, $source_id, $target_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserRoleEntry
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addUserRoleEntry. Assign user to role.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $user_id
     * @param string $role_id
     * @return boolean|bool
     */
    public function addUserRoleEntry($sid, $user_id, $role_id)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserRoleEntry($sid, $user_id, $role_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRole
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addRole(): Creates new role under given node. "target_id" is the reference id of an ILIAS ILIAS object. E.g ref_id of crs,grp. If no role folder exists, a new role folder will be created.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $obj_xml
     * @return int[]|bool
     */
    public function addRole($sid, $target_id, $obj_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addRole($sid, $target_id, $obj_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoleFromTemplate
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addRole(): Creates new role under given node. "target_id" is the reference id of an ILIAS ILIAS object. E.g ref_id of crs,grp. If no role folder exists, a new role folder will be created. In addition to addRole the template
     * permissions will be copied from the given role template
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $obj_xml
     * @param string $role_template_id
     * @return int[]|bool
     */
    public function addRoleFromTemplate($sid, $target_id, $obj_xml, $role_template_id)
    {
        try {
            $this->setResult(self::getSoapClient()->addRoleFromTemplate($sid, $target_id, $obj_xml, $role_template_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGroup
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addGroup(): Add grop according to valid group XML @See ilias_group_0_1.dtd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $group_xml
     * @return int|bool
     */
    public function addGroup($sid, $target_id, $group_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addGroup($sid, $target_id, $group_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addExercise
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addExercise(): create exercise, put it into target (ref_id) and update exercise properties from xml (see ilias_exercise_3_8.dtd for details). Obj_id must not be set!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $xml
     * @return int|bool
     */
    public function addExercise($sid, $target_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addExercise($sid, $target_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFile
     * Meta informations extracted from the WSDL
     * - documentation: ILIAS addFile(): create file, put it into target (ref_id) and update file properties from xml (see ilias_file_3_8.dtd for details). Obj_id must not be set!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sid
     * @param string $target_id
     * @param string $xml
     * @return int|bool
     */
    public function addFile($sid, $target_id, $xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addFile($sid, $target_id, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int|int[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
