<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemData StructType
 * @subpackage Structs
 */
class OrderItemData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockKeepingUnitId
     * @var int
     */
    public $stockKeepingUnitId;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The sellerDiscount
     * @var float
     */
    public $sellerDiscount;
    /**
     * The mallDiscount
     * @var float
     */
    public $mallDiscount;
    /**
     * The commission
     * @var float
     */
    public $commission;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The productName
     * @var string
     */
    public $productName;
    /**
     * The deliveryFeeType
     * @var int
     */
    public $deliveryFeeType;
    /**
     * The dueAmount
     * @var float
     */
    public $dueAmount;
    /**
     * The shipmentInfo
     * @var \StructType\OrderItemShipmentInfo
     */
    public $shipmentInfo;
    /**
     * The attributes
     * @var \StructType\SkuAttributeList
     */
    public $attributes;
    /**
     * The customTextOptionValues
     * @var \StructType\CustomTextOptionsDataList
     */
    public $customTextOptionValues;
    /**
     * The bundle
     * @var bool
     */
    public $bundle;
    /**
     * The updatedDate
     * @var string
     */
    public $updatedDate;
    /**
     * The cargoCompanyWarning
     * @var string
     */
    public $cargoCompanyWarning;
    /**
     * Constructor method for OrderItemData
     * @uses OrderItemData::setId()
     * @uses OrderItemData::setStockKeepingUnitId()
     * @uses OrderItemData::setProductSellerCode()
     * @uses OrderItemData::setPrice()
     * @uses OrderItemData::setSellerDiscount()
     * @uses OrderItemData::setMallDiscount()
     * @uses OrderItemData::setCommission()
     * @uses OrderItemData::setStatus()
     * @uses OrderItemData::setQuantity()
     * @uses OrderItemData::setProductName()
     * @uses OrderItemData::setDeliveryFeeType()
     * @uses OrderItemData::setDueAmount()
     * @uses OrderItemData::setShipmentInfo()
     * @uses OrderItemData::setAttributes()
     * @uses OrderItemData::setCustomTextOptionValues()
     * @uses OrderItemData::setBundle()
     * @uses OrderItemData::setUpdatedDate()
     * @uses OrderItemData::setCargoCompanyWarning()
     * @param int $id
     * @param int $stockKeepingUnitId
     * @param string $productSellerCode
     * @param float $price
     * @param float $sellerDiscount
     * @param float $mallDiscount
     * @param float $commission
     * @param int $status
     * @param int $quantity
     * @param string $productName
     * @param int $deliveryFeeType
     * @param float $dueAmount
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @param \StructType\SkuAttributeList $attributes
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     * @param bool $bundle
     * @param string $updatedDate
     * @param string $cargoCompanyWarning
     */
    public function __construct($id = null, $stockKeepingUnitId = null, $productSellerCode = null, $price = null, $sellerDiscount = null, $mallDiscount = null, $commission = null, $status = null, $quantity = null, $productName = null, $deliveryFeeType = null, $dueAmount = null, \StructType\OrderItemShipmentInfo $shipmentInfo = null, \StructType\SkuAttributeList $attributes = null, \StructType\CustomTextOptionsDataList $customTextOptionValues = null, $bundle = null, $updatedDate = null, $cargoCompanyWarning = null)
    {
        $this
            ->setId($id)
            ->setStockKeepingUnitId($stockKeepingUnitId)
            ->setProductSellerCode($productSellerCode)
            ->setPrice($price)
            ->setSellerDiscount($sellerDiscount)
            ->setMallDiscount($mallDiscount)
            ->setCommission($commission)
            ->setStatus($status)
            ->setQuantity($quantity)
            ->setProductName($productName)
            ->setDeliveryFeeType($deliveryFeeType)
            ->setDueAmount($dueAmount)
            ->setShipmentInfo($shipmentInfo)
            ->setAttributes($attributes)
            ->setCustomTextOptionValues($customTextOptionValues)
            ->setBundle($bundle)
            ->setUpdatedDate($updatedDate)
            ->setCargoCompanyWarning($cargoCompanyWarning);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderItemData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockKeepingUnitId value
     * @return int|null
     */
    public function getStockKeepingUnitId()
    {
        return $this->stockKeepingUnitId;
    }
    /**
     * Set stockKeepingUnitId value
     * @param int $stockKeepingUnitId
     * @return \StructType\OrderItemData
     */
    public function setStockKeepingUnitId($stockKeepingUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($stockKeepingUnitId) && !(is_int($stockKeepingUnitId) || ctype_digit($stockKeepingUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockKeepingUnitId, true), gettype($stockKeepingUnitId)), __LINE__);
        }
        $this->stockKeepingUnitId = $stockKeepingUnitId;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\OrderItemData
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\OrderItemData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get sellerDiscount value
     * @return float|null
     */
    public function getSellerDiscount()
    {
        return $this->sellerDiscount;
    }
    /**
     * Set sellerDiscount value
     * @param float $sellerDiscount
     * @return \StructType\OrderItemData
     */
    public function setSellerDiscount($sellerDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerDiscount) && !(is_float($sellerDiscount) || is_numeric($sellerDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerDiscount, true), gettype($sellerDiscount)), __LINE__);
        }
        $this->sellerDiscount = $sellerDiscount;
        return $this;
    }
    /**
     * Get mallDiscount value
     * @return float|null
     */
    public function getMallDiscount()
    {
        return $this->mallDiscount;
    }
    /**
     * Set mallDiscount value
     * @param float $mallDiscount
     * @return \StructType\OrderItemData
     */
    public function setMallDiscount($mallDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($mallDiscount) && !(is_float($mallDiscount) || is_numeric($mallDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mallDiscount, true), gettype($mallDiscount)), __LINE__);
        }
        $this->mallDiscount = $mallDiscount;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\OrderItemData
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderItemData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\OrderItemData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\OrderItemData
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get deliveryFeeType value
     * @return int|null
     */
    public function getDeliveryFeeType()
    {
        return $this->deliveryFeeType;
    }
    /**
     * Set deliveryFeeType value
     * @param int $deliveryFeeType
     * @return \StructType\OrderItemData
     */
    public function setDeliveryFeeType($deliveryFeeType = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryFeeType) && !(is_int($deliveryFeeType) || ctype_digit($deliveryFeeType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryFeeType, true), gettype($deliveryFeeType)), __LINE__);
        }
        $this->deliveryFeeType = $deliveryFeeType;
        return $this;
    }
    /**
     * Get dueAmount value
     * @return float|null
     */
    public function getDueAmount()
    {
        return $this->dueAmount;
    }
    /**
     * Set dueAmount value
     * @param float $dueAmount
     * @return \StructType\OrderItemData
     */
    public function setDueAmount($dueAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dueAmount) && !(is_float($dueAmount) || is_numeric($dueAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dueAmount, true), gettype($dueAmount)), __LINE__);
        }
        $this->dueAmount = $dueAmount;
        return $this;
    }
    /**
     * Get shipmentInfo value
     * @return \StructType\OrderItemShipmentInfo|null
     */
    public function getShipmentInfo()
    {
        return $this->shipmentInfo;
    }
    /**
     * Set shipmentInfo value
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @return \StructType\OrderItemData
     */
    public function setShipmentInfo(\StructType\OrderItemShipmentInfo $shipmentInfo = null)
    {
        $this->shipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\SkuAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\SkuAttributeList $attributes
     * @return \StructType\OrderItemData
     */
    public function setAttributes(\StructType\SkuAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get customTextOptionValues value
     * @return \StructType\CustomTextOptionsDataList|null
     */
    public function getCustomTextOptionValues()
    {
        return $this->customTextOptionValues;
    }
    /**
     * Set customTextOptionValues value
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     * @return \StructType\OrderItemData
     */
    public function setCustomTextOptionValues(\StructType\CustomTextOptionsDataList $customTextOptionValues = null)
    {
        $this->customTextOptionValues = $customTextOptionValues;
        return $this;
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\OrderItemData
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundle, true), gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Get updatedDate value
     * @return string|null
     */
    public function getUpdatedDate()
    {
        return $this->updatedDate;
    }
    /**
     * Set updatedDate value
     * @param string $updatedDate
     * @return \StructType\OrderItemData
     */
    public function setUpdatedDate($updatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($updatedDate) && !is_string($updatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedDate, true), gettype($updatedDate)), __LINE__);
        }
        $this->updatedDate = $updatedDate;
        return $this;
    }
    /**
     * Get cargoCompanyWarning value
     * @return string|null
     */
    public function getCargoCompanyWarning()
    {
        return $this->cargoCompanyWarning;
    }
    /**
     * Set cargoCompanyWarning value
     * @param string $cargoCompanyWarning
     * @return \StructType\OrderItemData
     */
    public function setCargoCompanyWarning($cargoCompanyWarning = null)
    {
        // validation for constraint: string
        if (!is_null($cargoCompanyWarning) && !is_string($cargoCompanyWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoCompanyWarning, true), gettype($cargoCompanyWarning)), __LINE__);
        }
        $this->cargoCompanyWarning = $cargoCompanyWarning;
        return $this;
    }
}
