<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemDataListRequest StructType
 * @subpackage Structs
 */
class OrderItemDataListRequest extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemDataRequest[]
     */
    public $orderItem;
    /**
     * Constructor method for OrderItemDataListRequest
     * @uses OrderItemDataListRequest::setOrderItem()
     * @param \StructType\OrderItemDataRequest[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemDataRequest[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDataRequest[] $orderItem
     * @return \StructType\OrderItemDataListRequest
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $orderItemDataListRequestOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemDataListRequestOrderItemItem instanceof \StructType\OrderItemDataRequest) {
                throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemDataRequest, "%s" given', is_object($orderItemDataListRequestOrderItemItem) ? get_class($orderItemDataListRequestOrderItemItem) : gettype($orderItemDataListRequestOrderItemItem)), __LINE__);
            }
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDataRequest $item
     * @return \StructType\OrderItemDataListRequest
     */
    public function addToOrderItem(\StructType\OrderItemDataRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemDataRequest) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemDataRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemDataListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
