<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDataList StructType
 * @subpackage Structs
 */
class OrderDataList extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderData[]
     */
    public $order;
    /**
     * Constructor method for OrderDataList
     * @uses OrderDataList::setOrder()
     * @param \StructType\OrderData[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\OrderData[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderData[] $order
     * @return \StructType\OrderDataList
     */
    public function setOrder(array $order = array())
    {
        foreach ($order as $orderDataListOrderItem) {
            // validation for constraint: itemType
            if (!$orderDataListOrderItem instanceof \StructType\OrderData) {
                throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\OrderData, "%s" given', is_object($orderDataListOrderItem) ? get_class($orderDataListOrderItem) : gettype($orderDataListOrderItem)), __LINE__);
            }
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderData $item
     * @return \StructType\OrderDataList
     */
    public function addToOrder(\StructType\OrderData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\OrderData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
