<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemRejectResponse StructType
 * @subpackage Structs
 */
class OrderItemRejectResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The orderItemList
     * @var \StructType\DetailedOrderItemDataList
     */
    public $orderItemList;
    /**
     * Constructor method for OrderItemRejectResponse
     * @uses OrderItemRejectResponse::setResult()
     * @uses OrderItemRejectResponse::setOrderItemList()
     * @param \StructType\ResultInfo $result
     * @param \StructType\DetailedOrderItemDataList $orderItemList
     */
    public function __construct(\StructType\ResultInfo $result = null, \StructType\DetailedOrderItemDataList $orderItemList = null)
    {
        $this
            ->setResult($result)
            ->setOrderItemList($orderItemList);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\OrderItemRejectResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\DetailedOrderItemDataList|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\DetailedOrderItemDataList $orderItemList
     * @return \StructType\OrderItemRejectResponse
     */
    public function setOrderItemList(\StructType\DetailedOrderItemDataList $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
}
