<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complementary ServiceType
 * @subpackage Services
 */
class Complementary extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ComplementaryItemDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComplementaryItemDetailRequest $complementaryItemDetailRequest
     * @return \StructType\ComplementaryItemDetailResponse|bool
     */
    public function ComplementaryItemDetail(\StructType\ComplementaryItemDetailRequest $complementaryItemDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ComplementaryItemDetail($complementaryItemDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ComplementaryItemDetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
