<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCompanyData StructType
 * @subpackage Structs
 */
class ShipmentCompanyData extends AbstractStructBase
{
    /**
     * The id
     * @var \StructType\Long
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The shortName
     * @var string
     */
    public $shortName;
    /**
     * Constructor method for ShipmentCompanyData
     * @uses ShipmentCompanyData::setId()
     * @uses ShipmentCompanyData::setName()
     * @uses ShipmentCompanyData::setShortName()
     * @param \StructType\Long $id
     * @param string $name
     * @param string $shortName
     */
    public function __construct(\StructType\Long $id = null, $name = null, $shortName = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setShortName($shortName);
    }
    /**
     * Get id value
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Long $id
     * @return \StructType\ShipmentCompanyData
     */
    public function setId(\StructType\Long $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ShipmentCompanyData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \StructType\ShipmentCompanyData
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->shortName = $shortName;
        return $this;
    }
}
