<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Buyer StructType
 * @subpackage Structs
 */
class Buyer extends AbstractStructBase
{
    /**
     * The id
     * @var \StructType\Long
     */
    public $id;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * Constructor method for Buyer
     * @uses Buyer::setId()
     * @uses Buyer::setFullName()
     * @param \StructType\Long $id
     * @param string $fullName
     */
    public function __construct(\StructType\Long $id = null, $fullName = null)
    {
        $this
            ->setId($id)
            ->setFullName($fullName);
    }
    /**
     * Get id value
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Long $id
     * @return \StructType\Buyer
     */
    public function setId(\StructType\Long $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\Buyer
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
}
