<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderData StructType
 * @subpackage Structs
 */
class OrderData extends AbstractStructBase
{
    /**
     * The id
     * @var \StructType\Long
     */
    public $id;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * The totalDiscountAmount
     * @var float
     */
    public $totalDiscountAmount;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $paymentType;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The totalAmount
     * @var float
     */
    public $totalAmount;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $status;
    /**
     * The citizenshipId
     * @var string
     */
    public $citizenshipId;
    /**
     * Constructor method for OrderData
     * @uses OrderData::setId()
     * @uses OrderData::setCreateDate()
     * @uses OrderData::setTotalDiscountAmount()
     * @uses OrderData::setPaymentType()
     * @uses OrderData::setOrderNumber()
     * @uses OrderData::setTotalAmount()
     * @uses OrderData::setStatus()
     * @uses OrderData::setCitizenshipId()
     * @param \StructType\Long $id
     * @param string $createDate
     * @param float $totalDiscountAmount
     * @param int $paymentType
     * @param string $orderNumber
     * @param float $totalAmount
     * @param int $status
     * @param string $citizenshipId
     */
    public function __construct(\StructType\Long $id = null, $createDate = null, $totalDiscountAmount = null, $paymentType = null, $orderNumber = null, $totalAmount = null, $status = null, $citizenshipId = null)
    {
        $this
            ->setId($id)
            ->setCreateDate($createDate)
            ->setTotalDiscountAmount($totalDiscountAmount)
            ->setPaymentType($paymentType)
            ->setOrderNumber($orderNumber)
            ->setTotalAmount($totalAmount)
            ->setStatus($status)
            ->setCitizenshipId($citizenshipId);
    }
    /**
     * Get id value
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Long $id
     * @return \StructType\OrderData
     */
    public function setId(\StructType\Long $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\OrderData
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get totalDiscountAmount value
     * @return float|null
     */
    public function getTotalDiscountAmount()
    {
        return $this->totalDiscountAmount;
    }
    /**
     * Set totalDiscountAmount value
     * @param float $totalDiscountAmount
     * @return \StructType\OrderData
     */
    public function setTotalDiscountAmount($totalDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalDiscountAmount) && !(is_float($totalDiscountAmount) || is_numeric($totalDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDiscountAmount, true), gettype($totalDiscountAmount)), __LINE__);
        }
        $this->totalDiscountAmount = $totalDiscountAmount;
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\OrderData
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderData
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\OrderData
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get citizenshipId value
     * @return string|null
     */
    public function getCitizenshipId()
    {
        return $this->citizenshipId;
    }
    /**
     * Set citizenshipId value
     * @param string $citizenshipId
     * @return \StructType\OrderData
     */
    public function setCitizenshipId($citizenshipId = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipId) && !is_string($citizenshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenshipId, true), gettype($citizenshipId)), __LINE__);
        }
        $this->citizenshipId = $citizenshipId;
        return $this;
    }
}
