<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSearchData StructType
 * @subpackage Structs
 */
class OrderSearchData extends AbstractStructBase
{
    /**
     * The id
     * @var \StructType\Long
     */
    public $id;
    /**
     * The productId
     * @var \StructType\Long
     */
    public $productId;
    /**
     * The deliveryFeeType
     * @var int
     */
    public $deliveryFeeType;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The rejectReason
     * @var string
     */
    public $rejectReason;
    /**
     * The approvedDate
     * @var string
     */
    public $approvedDate;
    /**
     * The dueAmount
     * @var float
     */
    public $dueAmount;
    /**
     * The installmentChargeWithVAT
     * @var float
     */
    public $installmentChargeWithVAT;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The totalMallDiscountPrice
     * @var float
     */
    public $totalMallDiscountPrice;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The sellerCouponDiscount
     * @var float
     */
    public $sellerCouponDiscount;
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The version
     * @var \StructType\Long
     */
    public $version;
    /**
     * The attributes
     * @var \StructType\SkuAttributeList
     */
    public $attributes;
    /**
     * The sellerDiscount
     * @var float
     */
    public $sellerDiscount;
    /**
     * The mallDiscount
     * @var float
     */
    public $mallDiscount;
    /**
     * The commission
     * @var float
     */
    public $commission;
    /**
     * The sellerInvoiceAmount
     * @var float
     */
    public $sellerInvoiceAmount;
    /**
     * The productName
     * @var string
     */
    public $productName;
    /**
     * The shipmentInfo
     * @var \StructType\OrderItemShipmentInfo
     */
    public $shipmentInfo;
    /**
     * The shippingDate
     * @var string
     */
    public $shippingDate;
    /**
     * The customTextOptionValues
     * @var \StructType\CustomTextOptionsDataList
     */
    public $customTextOptionValues;
    /**
     * The shipmenCompanyCampaignNumber
     * @var string
     */
    public $shipmenCompanyCampaignNumber;
    /**
     * Constructor method for OrderSearchData
     * @uses OrderSearchData::setId()
     * @uses OrderSearchData::setProductId()
     * @uses OrderSearchData::setDeliveryFeeType()
     * @uses OrderSearchData::setProductSellerCode()
     * @uses OrderSearchData::setStatus()
     * @uses OrderSearchData::setRejectReason()
     * @uses OrderSearchData::setApprovedDate()
     * @uses OrderSearchData::setDueAmount()
     * @uses OrderSearchData::setInstallmentChargeWithVAT()
     * @uses OrderSearchData::setPrice()
     * @uses OrderSearchData::setTotalMallDiscountPrice()
     * @uses OrderSearchData::setQuantity()
     * @uses OrderSearchData::setSellerCouponDiscount()
     * @uses OrderSearchData::setSellerStockCode()
     * @uses OrderSearchData::setVersion()
     * @uses OrderSearchData::setAttributes()
     * @uses OrderSearchData::setSellerDiscount()
     * @uses OrderSearchData::setMallDiscount()
     * @uses OrderSearchData::setCommission()
     * @uses OrderSearchData::setSellerInvoiceAmount()
     * @uses OrderSearchData::setProductName()
     * @uses OrderSearchData::setShipmentInfo()
     * @uses OrderSearchData::setShippingDate()
     * @uses OrderSearchData::setCustomTextOptionValues()
     * @uses OrderSearchData::setShipmenCompanyCampaignNumber()
     * @param \StructType\Long $id
     * @param \StructType\Long $productId
     * @param int $deliveryFeeType
     * @param string $productSellerCode
     * @param string $status
     * @param string $rejectReason
     * @param string $approvedDate
     * @param float $dueAmount
     * @param float $installmentChargeWithVAT
     * @param float $price
     * @param float $totalMallDiscountPrice
     * @param int $quantity
     * @param float $sellerCouponDiscount
     * @param string $sellerStockCode
     * @param \StructType\Long $version
     * @param \StructType\SkuAttributeList $attributes
     * @param float $sellerDiscount
     * @param float $mallDiscount
     * @param float $commission
     * @param float $sellerInvoiceAmount
     * @param string $productName
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @param string $shippingDate
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     * @param string $shipmenCompanyCampaignNumber
     */
    public function __construct(\StructType\Long $id = null, \StructType\Long $productId = null, $deliveryFeeType = null, $productSellerCode = null, $status = null, $rejectReason = null, $approvedDate = null, $dueAmount = null, $installmentChargeWithVAT = null, $price = null, $totalMallDiscountPrice = null, $quantity = null, $sellerCouponDiscount = null, $sellerStockCode = null, \StructType\Long $version = null, \StructType\SkuAttributeList $attributes = null, $sellerDiscount = null, $mallDiscount = null, $commission = null, $sellerInvoiceAmount = null, $productName = null, \StructType\OrderItemShipmentInfo $shipmentInfo = null, $shippingDate = null, \StructType\CustomTextOptionsDataList $customTextOptionValues = null, $shipmenCompanyCampaignNumber = null)
    {
        $this
            ->setId($id)
            ->setProductId($productId)
            ->setDeliveryFeeType($deliveryFeeType)
            ->setProductSellerCode($productSellerCode)
            ->setStatus($status)
            ->setRejectReason($rejectReason)
            ->setApprovedDate($approvedDate)
            ->setDueAmount($dueAmount)
            ->setInstallmentChargeWithVAT($installmentChargeWithVAT)
            ->setPrice($price)
            ->setTotalMallDiscountPrice($totalMallDiscountPrice)
            ->setQuantity($quantity)
            ->setSellerCouponDiscount($sellerCouponDiscount)
            ->setSellerStockCode($sellerStockCode)
            ->setVersion($version)
            ->setAttributes($attributes)
            ->setSellerDiscount($sellerDiscount)
            ->setMallDiscount($mallDiscount)
            ->setCommission($commission)
            ->setSellerInvoiceAmount($sellerInvoiceAmount)
            ->setProductName($productName)
            ->setShipmentInfo($shipmentInfo)
            ->setShippingDate($shippingDate)
            ->setCustomTextOptionValues($customTextOptionValues)
            ->setShipmenCompanyCampaignNumber($shipmenCompanyCampaignNumber);
    }
    /**
     * Get id value
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Long $id
     * @return \StructType\OrderSearchData
     */
    public function setId(\StructType\Long $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get productId value
     * @return \StructType\Long|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param \StructType\Long $productId
     * @return \StructType\OrderSearchData
     */
    public function setProductId(\StructType\Long $productId = null)
    {
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get deliveryFeeType value
     * @return int|null
     */
    public function getDeliveryFeeType()
    {
        return $this->deliveryFeeType;
    }
    /**
     * Set deliveryFeeType value
     * @param int $deliveryFeeType
     * @return \StructType\OrderSearchData
     */
    public function setDeliveryFeeType($deliveryFeeType = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryFeeType) && !(is_int($deliveryFeeType) || ctype_digit($deliveryFeeType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryFeeType, true), gettype($deliveryFeeType)), __LINE__);
        }
        $this->deliveryFeeType = $deliveryFeeType;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\OrderSearchData
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\OrderSearchData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get rejectReason value
     * @return string|null
     */
    public function getRejectReason()
    {
        return $this->rejectReason;
    }
    /**
     * Set rejectReason value
     * @param string $rejectReason
     * @return \StructType\OrderSearchData
     */
    public function setRejectReason($rejectReason = null)
    {
        // validation for constraint: string
        if (!is_null($rejectReason) && !is_string($rejectReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectReason, true), gettype($rejectReason)), __LINE__);
        }
        $this->rejectReason = $rejectReason;
        return $this;
    }
    /**
     * Get approvedDate value
     * @return string|null
     */
    public function getApprovedDate()
    {
        return $this->approvedDate;
    }
    /**
     * Set approvedDate value
     * @param string $approvedDate
     * @return \StructType\OrderSearchData
     */
    public function setApprovedDate($approvedDate = null)
    {
        // validation for constraint: string
        if (!is_null($approvedDate) && !is_string($approvedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvedDate, true), gettype($approvedDate)), __LINE__);
        }
        $this->approvedDate = $approvedDate;
        return $this;
    }
    /**
     * Get dueAmount value
     * @return float|null
     */
    public function getDueAmount()
    {
        return $this->dueAmount;
    }
    /**
     * Set dueAmount value
     * @param float $dueAmount
     * @return \StructType\OrderSearchData
     */
    public function setDueAmount($dueAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dueAmount) && !(is_float($dueAmount) || is_numeric($dueAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dueAmount, true), gettype($dueAmount)), __LINE__);
        }
        $this->dueAmount = $dueAmount;
        return $this;
    }
    /**
     * Get installmentChargeWithVAT value
     * @return float|null
     */
    public function getInstallmentChargeWithVAT()
    {
        return $this->installmentChargeWithVAT;
    }
    /**
     * Set installmentChargeWithVAT value
     * @param float $installmentChargeWithVAT
     * @return \StructType\OrderSearchData
     */
    public function setInstallmentChargeWithVAT($installmentChargeWithVAT = null)
    {
        // validation for constraint: float
        if (!is_null($installmentChargeWithVAT) && !(is_float($installmentChargeWithVAT) || is_numeric($installmentChargeWithVAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentChargeWithVAT, true), gettype($installmentChargeWithVAT)), __LINE__);
        }
        $this->installmentChargeWithVAT = $installmentChargeWithVAT;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\OrderSearchData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get totalMallDiscountPrice value
     * @return float|null
     */
    public function getTotalMallDiscountPrice()
    {
        return $this->totalMallDiscountPrice;
    }
    /**
     * Set totalMallDiscountPrice value
     * @param float $totalMallDiscountPrice
     * @return \StructType\OrderSearchData
     */
    public function setTotalMallDiscountPrice($totalMallDiscountPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalMallDiscountPrice) && !(is_float($totalMallDiscountPrice) || is_numeric($totalMallDiscountPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMallDiscountPrice, true), gettype($totalMallDiscountPrice)), __LINE__);
        }
        $this->totalMallDiscountPrice = $totalMallDiscountPrice;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\OrderSearchData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sellerCouponDiscount value
     * @return float|null
     */
    public function getSellerCouponDiscount()
    {
        return $this->sellerCouponDiscount;
    }
    /**
     * Set sellerCouponDiscount value
     * @param float $sellerCouponDiscount
     * @return \StructType\OrderSearchData
     */
    public function setSellerCouponDiscount($sellerCouponDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerCouponDiscount) && !(is_float($sellerCouponDiscount) || is_numeric($sellerCouponDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerCouponDiscount, true), gettype($sellerCouponDiscount)), __LINE__);
        }
        $this->sellerCouponDiscount = $sellerCouponDiscount;
        return $this;
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\OrderSearchData
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStockCode, true), gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get version value
     * @return \StructType\Long|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param \StructType\Long $version
     * @return \StructType\OrderSearchData
     */
    public function setVersion(\StructType\Long $version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\SkuAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\SkuAttributeList $attributes
     * @return \StructType\OrderSearchData
     */
    public function setAttributes(\StructType\SkuAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get sellerDiscount value
     * @return float|null
     */
    public function getSellerDiscount()
    {
        return $this->sellerDiscount;
    }
    /**
     * Set sellerDiscount value
     * @param float $sellerDiscount
     * @return \StructType\OrderSearchData
     */
    public function setSellerDiscount($sellerDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerDiscount) && !(is_float($sellerDiscount) || is_numeric($sellerDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerDiscount, true), gettype($sellerDiscount)), __LINE__);
        }
        $this->sellerDiscount = $sellerDiscount;
        return $this;
    }
    /**
     * Get mallDiscount value
     * @return float|null
     */
    public function getMallDiscount()
    {
        return $this->mallDiscount;
    }
    /**
     * Set mallDiscount value
     * @param float $mallDiscount
     * @return \StructType\OrderSearchData
     */
    public function setMallDiscount($mallDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($mallDiscount) && !(is_float($mallDiscount) || is_numeric($mallDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mallDiscount, true), gettype($mallDiscount)), __LINE__);
        }
        $this->mallDiscount = $mallDiscount;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\OrderSearchData
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get sellerInvoiceAmount value
     * @return float|null
     */
    public function getSellerInvoiceAmount()
    {
        return $this->sellerInvoiceAmount;
    }
    /**
     * Set sellerInvoiceAmount value
     * @param float $sellerInvoiceAmount
     * @return \StructType\OrderSearchData
     */
    public function setSellerInvoiceAmount($sellerInvoiceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerInvoiceAmount) && !(is_float($sellerInvoiceAmount) || is_numeric($sellerInvoiceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerInvoiceAmount, true), gettype($sellerInvoiceAmount)), __LINE__);
        }
        $this->sellerInvoiceAmount = $sellerInvoiceAmount;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\OrderSearchData
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get shipmentInfo value
     * @return \StructType\OrderItemShipmentInfo|null
     */
    public function getShipmentInfo()
    {
        return $this->shipmentInfo;
    }
    /**
     * Set shipmentInfo value
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @return \StructType\OrderSearchData
     */
    public function setShipmentInfo(\StructType\OrderItemShipmentInfo $shipmentInfo = null)
    {
        $this->shipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get shippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->shippingDate;
    }
    /**
     * Set shippingDate value
     * @param string $shippingDate
     * @return \StructType\OrderSearchData
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->shippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get customTextOptionValues value
     * @return \StructType\CustomTextOptionsDataList|null
     */
    public function getCustomTextOptionValues()
    {
        return $this->customTextOptionValues;
    }
    /**
     * Set customTextOptionValues value
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     * @return \StructType\OrderSearchData
     */
    public function setCustomTextOptionValues(\StructType\CustomTextOptionsDataList $customTextOptionValues = null)
    {
        $this->customTextOptionValues = $customTextOptionValues;
        return $this;
    }
    /**
     * Get shipmenCompanyCampaignNumber value
     * @return string|null
     */
    public function getShipmenCompanyCampaignNumber()
    {
        return $this->shipmenCompanyCampaignNumber;
    }
    /**
     * Set shipmenCompanyCampaignNumber value
     * @param string $shipmenCompanyCampaignNumber
     * @return \StructType\OrderSearchData
     */
    public function setShipmenCompanyCampaignNumber($shipmenCompanyCampaignNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmenCompanyCampaignNumber) && !is_string($shipmenCompanyCampaignNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmenCompanyCampaignNumber, true), gettype($shipmenCompanyCampaignNumber)), __LINE__);
        }
        $this->shipmenCompanyCampaignNumber = $shipmenCompanyCampaignNumber;
        return $this;
    }
}
