<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Buyer StructType
 * @subpackage Structs
 */
class Buyer extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * Constructor method for Buyer
     * @uses Buyer::setId()
     * @uses Buyer::setFullName()
     * @param int $id
     * @param string $fullName
     */
    public function __construct($id = null, $fullName = null)
    {
        $this
            ->setId($id)
            ->setFullName($fullName);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Buyer
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\Buyer
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
}
