<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Combine ServiceType
 * @subpackage Services
 */
class Combine extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CombineItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CombineItemsRequest $combineItemsRequest
     * @return \StructType\CombineItemsResponse|bool
     */
    public function CombineItems(\StructType\CombineItemsRequest $combineItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CombineItems($combineItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CombineItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
