<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestPagingData StructType
 * @subpackage Structs
 */
class RequestPagingData extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $currentPage;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageSize;
    /**
     * Constructor method for RequestPagingData
     * @uses RequestPagingData::setCurrentPage()
     * @uses RequestPagingData::setPageSize()
     * @param int $currentPage
     * @param int $pageSize
     */
    public function __construct($currentPage = null, $pageSize = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setPageSize($pageSize);
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\RequestPagingData
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\RequestPagingData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
}
