<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDataListRequest StructType
 * @subpackage Structs
 */
class OrderDataListRequest extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $productId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The buyerName
     * @var string
     */
    public $buyerName;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The productSellerCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $productSellerCode;
    /**
     * The recipient
     * @var string
     */
    public $recipient;
    /**
     * The sameDayDelivery
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $sameDayDelivery;
    /**
     * The period
     * @var \StructType\OrderSearchPeriod
     */
    public $period;
    /**
     * The sortForUpdateDate
     * @var bool
     */
    public $sortForUpdateDate;
    /**
     * Constructor method for OrderDataListRequest
     * @uses OrderDataListRequest::setProductId()
     * @uses OrderDataListRequest::setStatus()
     * @uses OrderDataListRequest::setBuyerName()
     * @uses OrderDataListRequest::setOrderNumber()
     * @uses OrderDataListRequest::setProductSellerCode()
     * @uses OrderDataListRequest::setRecipient()
     * @uses OrderDataListRequest::setSameDayDelivery()
     * @uses OrderDataListRequest::setPeriod()
     * @uses OrderDataListRequest::setSortForUpdateDate()
     * @param int $productId
     * @param string $status
     * @param string $buyerName
     * @param string $orderNumber
     * @param string $productSellerCode
     * @param string $recipient
     * @param bool $sameDayDelivery
     * @param \StructType\OrderSearchPeriod $period
     * @param bool $sortForUpdateDate
     */
    public function __construct($productId = null, $status = null, $buyerName = null, $orderNumber = null, $productSellerCode = null, $recipient = null, $sameDayDelivery = null, \StructType\OrderSearchPeriod $period = null, $sortForUpdateDate = null)
    {
        $this
            ->setProductId($productId)
            ->setStatus($status)
            ->setBuyerName($buyerName)
            ->setOrderNumber($orderNumber)
            ->setProductSellerCode($productSellerCode)
            ->setRecipient($recipient)
            ->setSameDayDelivery($sameDayDelivery)
            ->setPeriod($period)
            ->setSortForUpdateDate($sortForUpdateDate);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\OrderDataListRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\OrderDataListRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get buyerName value
     * @return string|null
     */
    public function getBuyerName()
    {
        return $this->buyerName;
    }
    /**
     * Set buyerName value
     * @param string $buyerName
     * @return \StructType\OrderDataListRequest
     */
    public function setBuyerName($buyerName = null)
    {
        // validation for constraint: string
        if (!is_null($buyerName) && !is_string($buyerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerName, true), gettype($buyerName)), __LINE__);
        }
        $this->buyerName = $buyerName;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderDataListRequest
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\OrderDataListRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param string $recipient
     * @return \StructType\OrderDataListRequest
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Get sameDayDelivery value
     * @return bool|null
     */
    public function getSameDayDelivery()
    {
        return $this->sameDayDelivery;
    }
    /**
     * Set sameDayDelivery value
     * @param bool $sameDayDelivery
     * @return \StructType\OrderDataListRequest
     */
    public function setSameDayDelivery($sameDayDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameDayDelivery) && !is_bool($sameDayDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameDayDelivery, true), gettype($sameDayDelivery)), __LINE__);
        }
        $this->sameDayDelivery = $sameDayDelivery;
        return $this;
    }
    /**
     * Get period value
     * @return \StructType\OrderSearchPeriod|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param \StructType\OrderSearchPeriod $period
     * @return \StructType\OrderDataListRequest
     */
    public function setPeriod(\StructType\OrderSearchPeriod $period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get sortForUpdateDate value
     * @return bool|null
     */
    public function getSortForUpdateDate()
    {
        return $this->sortForUpdateDate;
    }
    /**
     * Set sortForUpdateDate value
     * @param bool $sortForUpdateDate
     * @return \StructType\OrderDataListRequest
     */
    public function setSortForUpdateDate($sortForUpdateDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortForUpdateDate) && !is_bool($sortForUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sortForUpdateDate, true), gettype($sortForUpdateDate)), __LINE__);
        }
        $this->sortForUpdateDate = $sortForUpdateDate;
        return $this;
    }
}
