<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The authentication
     * @var \StructType\Authentication
     */
    public $authentication;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setAuthentication()
     * @param \StructType\Authentication $authentication
     */
    public function __construct(\StructType\Authentication $authentication = null)
    {
        $this
            ->setAuthentication($authentication);
    }
    /**
     * Get authentication value
     * @return \StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\BaseRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
}
